/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import com.raplix.util.memix.MemixAccessControlException;
import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.MemixIllegalStateException;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.message.MessageManager;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.memix.filesystem";
    public static final String EX_FILE_EXISTS = "util.memix.filesystem.EX_FILE_EXISTS";
    public static final String EX_BAD_FORMAT = "util.memix.filesystem.EX_BAD_FORMAT";
    public static final String EX_UNKNOWN_FILE = "util.memix.filesystem.EX_UNKNOWN_FILE";
    public static final String EX_UNKNOWN_FILE_REG = "util.memix.filesystem.EX_UNKNOWN_FILE_REG";
    public static final String EX_UNKNOWN_FILE_DIR = "util.memix.filesystem.EX_UNKNOWN_FILE_DIR";
    public static final String EX_UNKNOWN_FILE_MOUNT = "util.memix.filesystem.EX_UNKNOWN_FILE_MOUNT";
    public static final String EX_UNKNOWN_FILE_LINK = "util.memix.filesystem.EX_UNKNOWN_FILE_LINK";
    public static final String EX_NO_PERMISSION = "util.memix.filesystem.EX_NO_PERMISSION";
    public static final String EX_OVER_ROOT = "util.memix.filesystem.EX_OVER_ROOT";
    public static final String EX_CIRCULAR_LINK = "util.memix.filesystem.EX_CIRCULAR_LINK";
    public static final String EX_IS_DESCENDANT = "util.memix.filesystem.EX_IS_DESCENDANT";
    public static final String EX_NO_MATCH = "util.memix.filesystem.EX_NO_MATCH";
    public static final String EX_DIRECTORY_NOT_EMPTY = "util.memix.filesystem.EX_DIRECTORY_NOT_EMPTY";
    public static final String EX_IS_NOT_DIRECTORY = "util.memix.filesystem.EX_IS_NOT_DIRECTORY";
    public static final String EX_DRIVE_IS_FULL = "util.memix.filesystem.EX_DRIVE_IS_FULL";
    public static final String EX_DRIVE_IS_INCONSISTENT = "util.memix.filesystem.EX_DRIVE_IS_INCONSISTENT";

    private PackageInfo() {
    }

    public static void throwFileExists(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_FILE_EXISTS, new Object[]{ID2}));
    }

    public static void throwBadFormat(String str) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_BAD_FORMAT, new Object[]{str}));
    }

    public static void throwUnknownFile(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_FILE, new Object[]{ID2}));
    }

    public static void throwUnknownFileReg(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_FILE_REG, new Object[]{ID2}));
    }

    public static void throwUnknownFileDir(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_FILE_DIR, new Object[]{ID2}));
    }

    public static void throwUnknownFileMount(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_FILE_MOUNT, new Object[]{ID2}));
    }

    public static void throwUnknownFileLink(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_FILE_LINK, new Object[]{ID2}));
    }

    public static void throwNoPermission(FID ID2) {
        throw new MemixAccessControlException(MessageManager.messageAsString(EX_NO_PERMISSION, new Object[]{ID2}));
    }

    public static void throwOverRoot(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_OVER_ROOT, new Object[]{ID2}));
    }

    public static void throwCircularLink(FID ID2) {
        throw new MemixIllegalStateException(MessageManager.messageAsString(EX_CIRCULAR_LINK, new Object[]{ID2}));
    }

    public static void throwIsDescendant(FID ancestorID, FID descendantID) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_IS_DESCENDANT, new Object[]{descendantID, ancestorID}));
    }

    public static void throwNoMatch(FID pattern) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_NO_MATCH, new Object[]{pattern}));
    }

    public static void throwDirectoryNotEmpty(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_DIRECTORY_NOT_EMPTY, new Object[]{ID2}));
    }

    public static void throwIsNotDirectory(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_IS_NOT_DIRECTORY, new Object[]{ID2}));
    }

    public static void throwDriveIsFull(String name) {
        throw new MemixIllegalStateException(MessageManager.messageAsString(EX_DRIVE_IS_FULL, new Object[]{name}));
    }

    public static void throwDriveIsInconsistent(String name) {
        throw new MemixIllegalStateException(MessageManager.messageAsString(EX_DRIVE_IS_INCONSISTENT, new Object[]{name}));
    }
}

