/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.filesystem.MountNode;
import com.raplix.util.memix.filesystem.PackageInfo;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.users.UID;
import java.util.Hashtable;

public abstract class Node
implements Cloneable {
    public static final long MODIFIED_NOW = -1L;
    public static final boolean CHOWN_RESTRICTED = false;
    public static final String CUSTOM_DATA = "data";
    private DirectoryNode mParent;
    private FID mFileID;
    private UID mUserID;
    private GID mGroupID;
    private Mask mMask;
    private long mSize;
    private long mModified;
    private Hashtable mCustom = new Hashtable();

    public Node(FID fileID, UID userID, GID groupID, Mask mask, long size, long modified) {
        this.mFileID = fileID;
        this.mUserID = userID;
        this.mGroupID = groupID;
        this.mMask = mask;
        this.mSize = size;
        this.setModified(null, modified);
    }

    protected void setParent(DirectoryNode parent) {
        this.mParent = parent;
    }

    public DirectoryNode getParent() {
        return this.mParent;
    }

    protected void setFileID(FID ID2) {
        this.mFileID = ID2;
    }

    public FID getFileID() {
        return this.mFileID;
    }

    public void setUserID(ProcessContext context, UID ID2) {
        this.assertCanExecutePath(context);
        if (context != null) {
            boolean isPrivileged = context.isPrivileged();
            if (!isPrivileged && !context.isUser(this.getUserID())) {
                PackageInfo.throwNoPermission(this.getFileID());
            }
            if (!isPrivileged) {
                this.setMask(null, this.getMask().clear(3072));
            }
        }
        this.mUserID = ID2;
    }

    public UID getUserID() {
        return this.mUserID;
    }

    public void setGroupID(ProcessContext context, GID ID2) {
        this.assertCanExecutePath(context);
        if (context != null) {
            boolean isPrivileged = context.isPrivileged();
            if (!(isPrivileged || context.isUser(this.getUserID()) && context.isInGroup(ID2))) {
                PackageInfo.throwNoPermission(this.getFileID());
            }
            if (this instanceof FileNode && !isPrivileged) {
                this.setMask(null, this.getMask().clear(3072));
            }
        }
        this.mGroupID = ID2;
    }

    public GID getGroupID() {
        return this.mGroupID;
    }

    public void setMask(ProcessContext context, Mask mask) {
        this.assertCanExecutePath(context);
        if (context != null) {
            boolean isPrivileged = context.isPrivileged();
            if (!isPrivileged && !context.isUser(this.getUserID())) {
                PackageInfo.throwNoPermission(this.getFileID());
            }
            if (!(this instanceof DirectoryNode) && !isPrivileged) {
                mask = mask.clear(512);
            }
            if (!(isPrivileged || context.isInGroup(this.getGroupID()) || context.isGroup(this.getGroupID()))) {
                mask = mask.clear(1024);
            }
        }
        this.mMask = mask;
    }

    public Mask getMask() {
        return this.mMask;
    }

    public void setSize(ProcessContext context, long size) {
        this.assertCanWrite(context);
        this.getMount().getDrive().realloc(this.getSize(), size);
        this.mSize = size;
        this.setModified(context, -1L);
    }

    public long getSize() {
        return this.mSize;
    }

    public void setModified(ProcessContext context, long modified) {
        if (context != null && !context.isPrivileged() && !context.isUser(this.getUserID())) {
            PackageInfo.throwNoPermission(this.getFileID());
        }
        this.mModified = modified == -1L ? System.currentTimeMillis() : modified;
    }

    public long getModified() {
        return this.mModified;
    }

    public void setCustom(String key, Object value) {
        this.mCustom.put(key, value);
    }

    public void setCustom(Hashtable entries) {
        this.mCustom.clear();
        this.mCustom.putAll(entries);
    }

    public Object getCustom(String key) {
        return this.mCustom.get(key);
    }

    public Hashtable getCustom() {
        return (Hashtable)this.mCustom.clone();
    }

    public FID getFullFileID() {
        if (this.getParent() == null) {
            return this.getFileID();
        }
        return this.getParent().getFullFileID().append(this.getFileID());
    }

    public MountNode getMount() {
        Node mount = this;
        while (!(mount instanceof MountNode)) {
            mount = mount.getParent();
        }
        return (MountNode)mount;
    }

    public boolean isNotDescendant(DirectoryNode node) {
        if (node == this) {
            return false;
        }
        for (DirectoryNode n = this.getParent(); n != null; n = n.getParent()) {
            if (n != node) continue;
            return false;
        }
        return true;
    }

    public void assertIsNotDescendant(DirectoryNode node) {
        if (!this.isNotDescendant(node)) {
            PackageInfo.throwIsDescendant(node.getFileID(), this.getFileID());
        }
    }

    public boolean canRead(ProcessContext context) {
        if (context == null || context.isPrivileged()) {
            return true;
        }
        if (context.isUser(this.getUserID())) {
            return this.getMask().isUserReadable();
        }
        if (context.isInGroup(this.getGroupID())) {
            return this.getMask().isGroupReadable();
        }
        return this.getMask().isOthersReadable();
    }

    public void assertCanRead(ProcessContext context) {
        if (!this.canRead(context)) {
            PackageInfo.throwNoPermission(this.getFileID());
        }
    }

    public boolean canWrite(ProcessContext context) {
        if (context == null || context.isPrivileged()) {
            return true;
        }
        if (context.isUser(this.getUserID())) {
            return this.getMask().isUserWriteable();
        }
        if (context.isInGroup(this.getGroupID())) {
            return this.getMask().isGroupWriteable();
        }
        return this.getMask().isOthersWriteable();
    }

    public void assertCanWrite(ProcessContext context) {
        if (!this.canWrite(context)) {
            PackageInfo.throwNoPermission(this.getFileID());
        }
    }

    public boolean canExecute(ProcessContext context) {
        if (context == null) {
            return true;
        }
        if (context.isPrivileged()) {
            return this.getMask().isUserExecutable() || this.getMask().isGroupExecutable() || this.getMask().isOthersExecutable();
        }
        if (context.isUser(this.getUserID())) {
            return this.getMask().isUserExecutable();
        }
        if (context.isInGroup(this.getGroupID())) {
            return this.getMask().isGroupExecutable();
        }
        return this.getMask().isOthersExecutable();
    }

    public void assertCanExecute(ProcessContext context) {
        if (!this.canExecute(context)) {
            PackageInfo.throwNoPermission(this.getFileID());
        }
    }

    public void assertCanExecutePath(ProcessContext context) {
        for (DirectoryNode node = this.getParent(); node != null; node = node.getParent()) {
            node.assertCanExecute(context);
        }
    }

    public Node copy() {
        Node node = null;
        try {
            node = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        node.mCustom = new Hashtable();
        return node;
    }
}

