/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.PackageInfo;
import java.util.StringTokenizer;

public class Mask {
    public static final int MASK_SET_UID = 2048;
    public static final int MASK_SET_GID = 1024;
    public static final int MASK_STICKY = 512;
    public static final int MASK_U_R = 256;
    public static final int MASK_U_W = 128;
    public static final int MASK_U_X = 64;
    public static final int MASK_G_R = 32;
    public static final int MASK_G_W = 16;
    public static final int MASK_G_X = 8;
    public static final int MASK_O_R = 4;
    public static final int MASK_O_W = 2;
    public static final int MASK_O_X = 1;
    public static final int MASK_U_RW = 384;
    public static final int MASK_U_RWX = 448;
    public static final int MASK_U_ALL = 3008;
    public static final int MASK_G_RW = 48;
    public static final int MASK_G_RWX = 56;
    public static final int MASK_G_ALL = 1080;
    public static final int MASK_O_RW = 6;
    public static final int MASK_O_RWX = 7;
    public static final int MASK_O_ALL = 7;
    public static final int MASK_A_RW = 438;
    public static final int MASK_A_RWX = 511;
    public static final int MASK_A_ALL = 4095;
    private static final char C_READ = 'r';
    private static final char C_WRITE = 'w';
    private static final char C_EXECUTE = 'x';
    private static final char C_STICKY_EXEC = 't';
    private static final char C_STICKY_NOEXEC = 'T';
    private static final char C_SET_ID_EXEC = 's';
    private static final char C_SET_ID_NOEXEC = 'S';
    private static final char C_MISSING = '-';
    private int mMask;

    public Mask(int mask) {
        this.mMask = mask;
    }

    public Mask(String mask) {
        this.mMask = Integer.parseInt(mask, 8);
    }

    private static void addBlock(StringBuffer buffer, boolean isReadable, boolean isWriteable, boolean isExecutable, boolean isExtra, char extraExec, char extraNoExec) {
        if (isReadable) {
            buffer.append('r');
        } else {
            buffer.append('-');
        }
        if (isWriteable) {
            buffer.append('w');
        } else {
            buffer.append('-');
        }
        if (isExtra) {
            if (isExecutable) {
                buffer.append(extraExec);
            } else {
                buffer.append(extraNoExec);
            }
        } else if (isExecutable) {
            buffer.append('x');
        } else {
            buffer.append('-');
        }
    }

    public Mask restrict(int mask) {
        return new Mask(this.mMask & mask);
    }

    public Mask clear(int mask) {
        return new Mask(this.mMask & ~mask);
    }

    public Mask augment(int mask) {
        return new Mask(this.mMask | mask);
    }

    public Mask chmod(ProcessContext context, String mode) {
        if (Character.isDigit(mode.charAt(0))) {
            return new Mask(mode);
        }
        Mask newMask = new Mask(this.getMask());
        StringTokenizer t = new StringTokenizer(mode, ",");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            char op = '\u0000';
            char[] ops = new char[]{'+', '-', '='};
            int index = -1;
            for (int i = 0; i < ops.length && index == -1; ++i) {
                op = ops[i];
                index = token.indexOf(op);
            }
            if (index == -1) {
                PackageInfo.throwBadFormat(token);
            }
            int tokenMask = 0;
            String who = token.substring(0, index);
            boolean u = false;
            boolean g = false;
            boolean o = false;
            if (who.length() == 0) {
                u = true;
                g = true;
                o = true;
            }
            block20: for (int i = 0; i < who.length(); ++i) {
                switch (who.charAt(i)) {
                    case 'u': {
                        u = true;
                        continue block20;
                    }
                    case 'g': {
                        g = true;
                        continue block20;
                    }
                    case 'o': {
                        o = true;
                        continue block20;
                    }
                    case 'a': {
                        u = true;
                        g = true;
                        o = true;
                        continue block20;
                    }
                    default: {
                        PackageInfo.throwBadFormat(who);
                    }
                }
            }
            String permissions = token.substring(index + 1);
            block21: for (int i = 0; i < permissions.length(); ++i) {
                switch (permissions.charAt(i)) {
                    case 'r': {
                        if (u) {
                            tokenMask |= 0x100;
                        }
                        if (g) {
                            tokenMask |= 0x20;
                        }
                        if (!o) continue block21;
                        tokenMask |= 4;
                        continue block21;
                    }
                    case 'w': {
                        if (u) {
                            tokenMask |= 0x80;
                        }
                        if (g) {
                            tokenMask |= 0x10;
                        }
                        if (!o) continue block21;
                        tokenMask |= 2;
                        continue block21;
                    }
                    case 'x': {
                        if (u) {
                            tokenMask |= 0x40;
                        }
                        if (g) {
                            tokenMask |= 8;
                        }
                        if (!o) continue block21;
                        tokenMask |= 1;
                        continue block21;
                    }
                    case 's': {
                        if (u) {
                            tokenMask |= 0x800;
                        }
                        if (!g) continue block21;
                        tokenMask |= 0x400;
                        continue block21;
                    }
                    case 't': {
                        if (!u) continue block21;
                        tokenMask |= 0x200;
                        continue block21;
                    }
                    default: {
                        PackageInfo.throwBadFormat(permissions);
                    }
                }
            }
            if (who.length() == 0 && context != null) {
                tokenMask &= ~context.getProcessEntry().getMask().getMask();
            }
            switch (op) {
                case '+': {
                    newMask = newMask.augment(tokenMask);
                    break;
                }
                case '-': {
                    newMask = newMask.clear(tokenMask);
                    break;
                }
                case '=': {
                    if (!u) {
                        tokenMask |= newMask.getMask() & 0xBC0;
                    }
                    if (!g) {
                        tokenMask |= newMask.getMask() & 0x438;
                    }
                    if (!o) {
                        tokenMask |= newMask.getMask() & 7;
                    }
                    newMask = new Mask(tokenMask);
                }
            }
        }
        return newMask;
    }

    public int getMask() {
        return this.mMask;
    }

    public boolean isSetUID() {
        return (this.mMask & 0x800) != 0;
    }

    public boolean isSetGID() {
        return (this.mMask & 0x400) != 0;
    }

    public boolean isSticky() {
        return (this.mMask & 0x200) != 0;
    }

    public boolean isUserReadable() {
        return (this.mMask & 0x100) != 0;
    }

    public boolean isUserWriteable() {
        return (this.mMask & 0x80) != 0;
    }

    public boolean isUserExecutable() {
        return (this.mMask & 0x40) != 0;
    }

    public boolean isGroupReadable() {
        return (this.mMask & 0x20) != 0;
    }

    public boolean isGroupWriteable() {
        return (this.mMask & 0x10) != 0;
    }

    public boolean isGroupExecutable() {
        return (this.mMask & 8) != 0;
    }

    public boolean isOthersReadable() {
        return (this.mMask & 4) != 0;
    }

    public boolean isOthersWriteable() {
        return (this.mMask & 2) != 0;
    }

    public boolean isOthersExecutable() {
        return (this.mMask & 1) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.getMask() == ((Mask)o).getMask();
    }

    public int hashCode() {
        return this.getMask();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Mask.addBlock(buffer, this.isUserReadable(), this.isUserWriteable(), this.isUserExecutable(), this.isSetUID(), 's', 'S');
        Mask.addBlock(buffer, this.isGroupReadable(), this.isGroupWriteable(), this.isGroupExecutable(), this.isSetGID(), 's', 'S');
        Mask.addBlock(buffer, this.isOthersReadable(), this.isOthersWriteable(), this.isOthersExecutable(), this.isSticky(), 't', 'T');
        return buffer.toString();
    }
}

