/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import [Lcom.raplix.util.memix.filesystem.FID;;
import [Lcom.raplix.util.memix.filesystem.Node;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.memix.Host;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.Drive;
import com.raplix.util.memix.filesystem.ExternalFileSystem;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.filesystem.MountNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.filesystem.PackageInfo;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.users.UID;
import com.raplix.util.regex.REUtil;
import com.raplix.util.regex.RegEx;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class FileSystem
implements ExternalFileSystem {
    private MountNode mRoot;

    public FileSystem(Mask mask, UID userID, GID groupID, Drive drive) {
        this.mRoot = new MountNode(FID.ID_ROOT, userID, groupID, mask, null, drive);
    }

    public FileSystem(ExternalFileSystem externalFileSystem) {
        this.mRoot = externalFileSystem.getRootNode();
    }

    private Node getNode(ProcessContext context, NodePointer pointer, boolean follow, Stack expanded) {
        DirectoryNode parent = pointer.getID().isRelative() ? pointer.getParent() : this.getRoot();
        FID[] IDs = pointer.getID().split();
        for (int i = 0; i < IDs.length; ++i) {
            boolean isLast;
            if (parent == null) {
                PackageInfo.throwOverRoot(pointer.getID());
            }
            if (IDs[i].isThisDir()) continue;
            if (IDs[i].isParentDir()) {
                parent = parent.getParent();
                continue;
            }
            Node n = parent.getChild(context, IDs[i]);
            boolean bl = isLast = i == IDs.length - 1;
            if (n instanceof LinkNode) {
                if (isLast && !follow) {
                    return n;
                }
                if (expanded.contains(n)) {
                    PackageInfo.throwCircularLink(IDs[i]);
                }
                expanded.push(n);
                n = this.getNode(context, new NodePointer(parent, ((LinkNode)n).getSource()), true, expanded);
                expanded.pop();
            }
            if (n instanceof FileNode) {
                if (isLast) {
                    return n;
                }
                PackageInfo.throwIsNotDirectory(IDs[i]);
            }
            if (!(n instanceof DirectoryNode)) continue;
            parent = (DirectoryNode)n;
        }
        if (parent == null) {
            PackageInfo.throwOverRoot(pointer.getID());
        }
        return parent;
    }

    public void init(Host host) {
    }

    public MountNode getRootNode() {
        MountNode mountNode = (MountNode)this.getRoot().copy();
        mountNode.setExternalFileSystem(this);
        return mountNode;
    }

    public Node[] getNodes(FID ID2) {
        DirectoryNode node = this.getDirectoryNode(null, ID2);
        FID[] childrenIDs = node.getChildren(null);
        Vector<Node> children = new Vector<Node>();
        for (int i = 0; i < childrenIDs.length; ++i) {
            if (childrenIDs[i].equals(FID.ID_THIS) || childrenIDs[i].equals(FID.ID_PARENT)) continue;
            children.addElement(node.getChild(null, childrenIDs[i]).copy());
        }
        return (Node[])CollectionUtil.mapClass(children, Node;.class);
    }

    public MountNode getRoot() {
        return this.mRoot;
    }

    public Node getNode(ProcessContext context, NodePointer pointer, boolean follow) {
        return this.getNode(context, pointer, follow, new Stack());
    }

    public Node getNode(ProcessContext context, FID ID2, boolean follow) {
        if (ID2.isRelative()) {
            ID2 = context.getProcessEntry().getWorkingDirectory().append(ID2);
        }
        return this.getNode(context, new NodePointer(null, ID2), follow);
    }

    public MountNode getMountNode(ProcessContext context, FID ID2) {
        Node n = this.getNode(context, ID2, true);
        if (n instanceof MountNode) {
            return (MountNode)n;
        }
        PackageInfo.throwUnknownFileMount(ID2);
        return null;
    }

    public DirectoryNode getDirectoryNode(ProcessContext context, FID ID2) {
        Node n = this.getNode(context, ID2, true);
        if (n instanceof DirectoryNode) {
            return (DirectoryNode)n;
        }
        PackageInfo.throwUnknownFileDir(ID2);
        return null;
    }

    public FileNode getFileNode(ProcessContext context, FID ID2) {
        Node n = this.getNode(context, ID2, true);
        if (n instanceof FileNode) {
            return (FileNode)n;
        }
        PackageInfo.throwUnknownFileReg(ID2);
        return null;
    }

    public LinkNode getLinkNode(ProcessContext context, FID ID2) {
        Node n = this.getNode(context, ID2, false);
        if (n instanceof LinkNode) {
            return (LinkNode)n;
        }
        PackageInfo.throwUnknownFileLink(ID2);
        return null;
    }

    public NodePointer split(ProcessContext context, FID ID2) {
        FID[] IDs = ID2.split();
        if (IDs.length == 0) {
            return new NodePointer(null, FID.ID_ROOT);
        }
        ID2 = ID2.isRelative() ? FID.ID_THIS : FID.ID_ROOT;
        for (int i = 0; i < IDs.length - 1; ++i) {
            ID2 = ID2.append(IDs[i]);
        }
        return new NodePointer(this.getDirectoryNode(context, ID2), IDs[IDs.length - 1]);
    }

    public boolean exists(ProcessContext context, NodePointer pointer) {
        return pointer.getParent() == null || pointer.getParent().hasChild(context, pointer.getID());
    }

    public FID[] expandGlob(ProcessContext context, FID pattern) {
        boolean prepend;
        FID[] IDs = pattern.split();
        Vector<FID> prevSet = new Vector<FID>();
        boolean bl = prepend = !pattern.isRelative();
        if (prepend) {
            prevSet.addElement(FID.ID_ROOT);
        } else {
            prevSet.addElement(FID.ID_THIS);
        }
        Vector<FID> newSet = new Vector<FID>();
        for (int i = 0; i < IDs.length; ++i) {
            RegEx re = REUtil.compileWildcard(IDs[i].toString());
            Enumeration e = prevSet.elements();
            while (e.hasMoreElements()) {
                FID parent = (FID)e.nextElement();
                DirectoryNode node = this.getDirectoryNode(context, parent);
                FID[] children = node.getChildren(context);
                boolean dirOnly = i < IDs.length - 1;
                for (int j = 0; j < children.length; ++j) {
                    Node child;
                    if (!re.match(children[j].toString()) || children[j].isHidden() && !IDs[i].isHidden() || dirOnly && !((child = this.getNode(context, new NodePointer(node, children[j]), true)) instanceof DirectoryNode)) continue;
                    if (prepend) {
                        newSet.addElement(parent.append(children[j]));
                        continue;
                    }
                    newSet.addElement(children[j]);
                }
                prepend = true;
            }
            Vector<FID> tmpSet = prevSet;
            prevSet = newSet;
            newSet = tmpSet;
            newSet.setSize(0);
        }
        if (prevSet.size() == 0) {
            PackageInfo.throwNoMatch(pattern);
        }
        return (FID[])CollectionUtil.mapClass(prevSet, FID;.class);
    }

    public static MountNode mount(ProcessContext context, NodePointer pointer, ExternalFileSystem externalFileSystem) {
        MountNode node = externalFileSystem.getRootNode();
        pointer.getParent().addChild(context, node);
        return node;
    }

    public MountNode mount(ProcessContext context, FID ID2, ExternalFileSystem externalFileSystem) {
        return FileSystem.mount(context, this.split(context, ID2), externalFileSystem);
    }

    public static DirectoryNode mkdir(ProcessContext context, NodePointer pointer) {
        DirectoryNode parent = pointer.getParent();
        Mask mask = new Mask(511);
        if (parent.getMask().isSetGID()) {
            mask = mask.augment(1024);
        }
        DirectoryNode node = new DirectoryNode(pointer.getID(), context.getUserID(), context.getGroupID(), mask);
        parent.addChild(context, node);
        return node;
    }

    public DirectoryNode mkdir(ProcessContext context, FID ID2) {
        return FileSystem.mkdir(context, this.split(context, ID2));
    }

    public void mkdirs(ProcessContext context, FID ID2) {
        FID[] IDs = ID2.split();
        if (IDs.length < 2) {
            return;
        }
        ID2 = ID2.isRelative() ? FID.ID_THIS : FID.ID_ROOT;
        DirectoryNode parent = this.getDirectoryNode(context, ID2);
        for (int i = 0; i < IDs.length - 1; ++i) {
            NodePointer pointer = new NodePointer(parent, IDs[i]);
            if (this.exists(context, pointer)) {
                Node node = this.getNode(context, pointer, true);
                if (node instanceof DirectoryNode) {
                    parent = (DirectoryNode)node;
                    continue;
                }
                PackageInfo.throwIsNotDirectory(IDs[i]);
                continue;
            }
            parent = FileSystem.mkdir(context, pointer);
        }
    }

    public static FileNode creat(ProcessContext context, NodePointer pointer) {
        FileNode node = new FileNode(pointer.getID(), context.getUserID(), context.getGroupID(), new Mask(438), 0L, -1L);
        pointer.getParent().addChild(context, node);
        return node;
    }

    public FileNode creat(ProcessContext context, FID ID2) {
        return FileSystem.creat(context, this.split(context, ID2));
    }

    public static LinkNode ln(ProcessContext context, NodePointer pointer, FID source) {
        LinkNode node = new LinkNode(pointer.getID(), context.getUserID(), context.getGroupID(), new Mask(511), source);
        pointer.getParent().addChild(context, node);
        return node;
    }

    public LinkNode ln(ProcessContext context, FID ID2, FID source) {
        return FileSystem.ln(context, this.split(context, ID2), source);
    }
}

