/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import java.util.StringTokenizer;

public class FID
implements Comparable {
    public static final String SEPARATOR = "/";
    public static final String HIDDEN_PREFIX = ".";
    public static final FID ID_ROOT = new FID("/");
    public static final FID ID_THIS = new FID(".");
    public static final FID ID_PARENT = new FID("..");
    public static final FID ID_EMPTY = new FID("");
    private String mValue;

    public FID(String value) {
        this.mValue = value;
    }

    public FID append(String value) {
        if (this.mValue.endsWith(SEPARATOR)) {
            return new FID(this.mValue + value);
        }
        return new FID(this.mValue + SEPARATOR + value);
    }

    public FID append(FID ID2) {
        return this.append(ID2.mValue);
    }

    public boolean isHidden() {
        return this.mValue.startsWith(HIDDEN_PREFIX);
    }

    public boolean isRelative() {
        return !this.mValue.startsWith(SEPARATOR);
    }

    public boolean isThisDir() {
        return this.mValue.equals(FID.ID_THIS.mValue);
    }

    public boolean isParentDir() {
        return this.mValue.equals(FID.ID_PARENT.mValue);
    }

    public int getSize() {
        return this.mValue.getBytes().length;
    }

    public FID[] split() {
        StringTokenizer t = new StringTokenizer(this.mValue, SEPARATOR);
        FID[] IDs = new FID[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            IDs[i++] = new FID(t.nextToken());
        }
        return IDs;
    }

    public int compareTo(Object o) {
        return this.mValue.compareTo(((FID)o).mValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.mValue.equals(((FID)o).mValue);
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public String toString() {
        return this.mValue;
    }
}

