/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import com.raplix.util.memix.filesystem.PackageInfo;

public class Drive {
    private String mName;
    private long mBlockSize;
    private long mTotalBlocks;
    private long mFreeBlocks;

    public Drive(String name, long blockSize, long totalBlocks, long freeBlocks) {
        this.mName = name;
        this.mBlockSize = blockSize;
        this.mTotalBlocks = totalBlocks;
        this.mFreeBlocks = freeBlocks;
    }

    public String getName() {
        return this.mName;
    }

    public long getBlockSize() {
        return this.mBlockSize;
    }

    public synchronized long getTotalBlocks() {
        return this.mTotalBlocks;
    }

    public synchronized long getFreeBlocks() {
        return this.mFreeBlocks;
    }

    public synchronized long getUsedBlocks() {
        return this.getTotalBlocks() - this.getFreeBlocks();
    }

    public long getBlocks(long bytes) {
        return (bytes + this.getBlockSize() - 1L) / this.getBlockSize();
    }

    public synchronized void alloc(long bytes) {
        this.realloc(0L, bytes);
    }

    public synchronized void release(long bytes) {
        this.realloc(bytes, 0L);
    }

    public synchronized void realloc(long oldBytes, long newBytes) {
        if (this.mTotalBlocks <= 0L) {
            return;
        }
        long oldBlocks = this.getBlocks(oldBytes);
        long newBlocks = this.getBlocks(newBytes);
        long changeBlocks = newBlocks - oldBlocks;
        if (changeBlocks > 0L) {
            if (this.mFreeBlocks < changeBlocks) {
                PackageInfo.throwDriveIsFull(this.getName());
            }
            this.mFreeBlocks -= changeBlocks;
            return;
        }
        if (this.mFreeBlocks + (changeBlocks = -changeBlocks) > this.mTotalBlocks) {
            PackageInfo.throwDriveIsInconsistent(this.getName());
        }
        this.mFreeBlocks += changeBlocks;
    }
}

