/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.filesystem;

import [Lcom.raplix.util.memix.filesystem.FID;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.filesystem.ExternalFileSystem;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.filesystem.PackageInfo;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.users.UID;
import java.util.Hashtable;
import java.util.Vector;

public class DirectoryNode
extends Node {
    public static final long SIZE = 4096L;
    private boolean mLoaded = false;
    private Hashtable mChildren = new Hashtable();

    public DirectoryNode(FID fileID, UID userID, GID groupID, Mask mask, long size, long modified) {
        super(fileID, userID, groupID, mask, size, modified);
    }

    public DirectoryNode(FID fileID, UID userID, GID groupID, Mask mask) {
        this(fileID, userID, groupID, mask, 4096L, -1L);
    }

    private synchronized void load() {
        if (this.mLoaded) {
            return;
        }
        this.mLoaded = true;
        ExternalFileSystem external = this.getMount().getExternalFileSystem();
        if (external == null) {
            return;
        }
        Node[] nodes = external.getNodes(this.getFullFileID());
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].setParent(this);
            this.mChildren.put(nodes[i].getFileID(), nodes[i]);
        }
    }

    private void assertCanExecuteAll(ProcessContext context) {
        this.assertCanExecute(context);
        this.assertCanExecutePath(context);
    }

    private synchronized void removeChild(ProcessContext context, FID ID2, boolean checkChild) {
        this.load();
        Node child = this.getChild(null, ID2);
        this.assertCanWrite(context);
        this.assertCanExecuteAll(context);
        if (!(context == null || !this.getMask().isSticky() || context.isPrivileged() || context.isUser(this.getUserID()) || context.isUser(child.getUserID()) || child.canWrite(context))) {
            PackageInfo.throwNoPermission(this.getFileID());
        }
        if (checkChild && child instanceof DirectoryNode && ((DirectoryNode)child).hasChildren(null)) {
            PackageInfo.throwDirectoryNotEmpty(child.getFileID());
        }
        this.getMount().getDrive().release(child.getSize());
        this.setModified(null, -1L);
        this.mChildren.remove(ID2);
    }

    public boolean canExecute(ProcessContext context) {
        if (context == null || context.isPrivileged()) {
            return true;
        }
        if (context.isUser(this.getUserID())) {
            return this.getMask().isUserExecutable();
        }
        if (context.isInGroup(this.getGroupID())) {
            return this.getMask().isUserExecutable();
        }
        return this.getMask().isOthersExecutable();
    }

    public Node copy() {
        DirectoryNode node = (DirectoryNode)super.copy();
        node.mLoaded = false;
        node.mChildren = new Hashtable();
        return node;
    }

    public synchronized void addChild(ProcessContext context, Node node) {
        this.load();
        this.assertCanExecuteAll(context);
        this.assertCanWrite(context);
        if (this.hasChild(null, node.getFileID())) {
            PackageInfo.throwFileExists(node.getFileID());
        }
        if (node.getParent() == null && context != null) {
            if (this.getMask().isSetGID() && context.isInGroup(this.getGroupID())) {
                node.setGroupID(null, this.getGroupID());
            }
            if (!context.isInGroup(node.getGroupID()) && !context.isGroup(node.getGroupID())) {
                node.setMask(null, node.getMask().clear(1024));
            }
            if (!(node instanceof LinkNode)) {
                node.setMask(null, node.getMask().clear(context.getProcessEntry().getMask().getMask()));
            }
        }
        this.getMount().getDrive().alloc(node.getSize());
        this.setModified(null, -1L);
        this.mChildren.put(node.getFileID(), node);
        node.setParent(this);
        if (node instanceof DirectoryNode) {
            ((DirectoryNode)node).mLoaded = true;
        }
    }

    public synchronized void addChild(ProcessContext context, Node node, FID ID2) {
        node.setFileID(ID2);
        this.addChild(context, node);
    }

    public boolean hasChild(ProcessContext context, FID ID2) {
        this.load();
        this.assertCanExecuteAll(context);
        return this.mChildren.get(ID2) != null;
    }

    public boolean hasChildren(ProcessContext context) {
        this.load();
        this.assertCanExecuteAll(context);
        return this.mChildren.size() > 0;
    }

    public Node getChild(ProcessContext context, FID ID2) {
        Node n;
        this.load();
        this.assertCanExecuteAll(context);
        if (ID2.equals(FID.ID_THIS)) {
            return this;
        }
        if (ID2.equals(FID.ID_PARENT)) {
            if (this.getParent() != null) {
                return this.getParent();
            }
            PackageInfo.throwUnknownFile(ID2);
        }
        if ((n = (Node)this.mChildren.get(ID2)) != null) {
            return n;
        }
        PackageInfo.throwUnknownFile(ID2);
        return null;
    }

    public void removeChild(ProcessContext context, FID ID2) {
        this.removeChild(context, ID2, true);
    }

    public synchronized void moveChild(ProcessContext context, FID ID2, NodePointer pointer) {
        DirectoryNode parent;
        if (this == pointer.getParent() && ID2.equals(pointer.getID())) {
            return;
        }
        Node child = this.getChild(null, ID2);
        if (child instanceof DirectoryNode) {
            pointer.getParent().assertIsNotDescendant((DirectoryNode)child);
        }
        if ((parent = pointer.getParent()).hasChild(context, pointer.getID())) {
            parent.removeChild(context, pointer.getID());
        }
        this.removeChild(context, ID2, false);
        parent.addChild(context, child, pointer.getID());
    }

    public FID[] getChildren(ProcessContext context) {
        this.load();
        this.assertCanExecuteAll(context);
        this.assertCanRead(context);
        Vector<FID> children = new Vector<FID>();
        children.add(FID.ID_THIS);
        if (this.getParent() != null) {
            children.add(FID.ID_PARENT);
        }
        children.addAll(this.mChildren.keySet());
        return (FID[])CollectionUtil.mapClass(children, FID;.class);
    }
}

