/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class UnZipCommand
extends Command {
    public UnZipCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, ZipException {
        FID ID2;
        File file;
        ProcessTableEntry pe = this.getProcessEntry();
        FileSystem f = this.getHost().getFileSystem();
        String[] args = pe.getArguments();
        if (args.length != 2) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        if ((file = (File)f.getFileNode(this, ID2 = new FID(args[1])).getCustom("data")) == null) {
            PackageInfo.throwMissingData(ID2);
        }
        ZipFile zip = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Node node;
                ZipEntry entry = e.nextElement();
                ID2 = new FID(entry.getName());
                f.mkdirs(this, ID2);
                NodePointer pointer = f.split(this, ID2);
                boolean exists = f.exists(this, pointer);
                if (entry.isDirectory()) {
                    node = exists ? f.getNode((ProcessContext)this, pointer, true) : f.mkdir(this, ID2);
                } else {
                    if (exists) {
                        pointer.getParent().removeChild(this, pointer.getID());
                    }
                    node = f.creat(this, ID2);
                    node.setSize(this, entry.getSize());
                }
                node.setModified(this, entry.getTime());
            }
        }
        finally {
            zip.close();
        }
        this.kill();
    }
}

