/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.commands.TouchFactory;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;

public class TouchCommand
extends Command {
    private static final String FORMAT = "MMddHHmmyy";

    public TouchCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() throws ParseException {
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, TouchFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 1) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean parents = args.get("-p") != null;
        long modified = -1L;
        if (args.get("-t") != null) {
            modified = new SimpleDateFormat(FORMAT).parse(((String[])args.get("-t"))[0]).getTime();
        }
        long size = -1L;
        if (args.get("-s") != null) {
            size = Long.parseLong(((String[])args.get("-s"))[0]);
        }
        for (int i = 0; i < tailArgs.length; ++i) {
            NodePointer pointer;
            FID ID2 = new FID(tailArgs[i]);
            if (parents) {
                f.mkdirs(this, ID2);
            }
            Node node = f.exists(this, pointer = f.split(this, ID2)) ? f.getNode((ProcessContext)this, pointer, true) : FileSystem.creat(this, pointer);
            if (size != -1L) {
                node.setSize(this, size);
            }
            node.setModified(this, modified);
        }
        this.kill();
    }
}

