/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.commands.SuFactory;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.UserTableEntry;
import com.raplix.util.memix.users.Users;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class SuCommand
extends Command {
    public SuCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        FileSystem f = this.getHost().getFileSystem();
        Users u = this.getHost().getUsers();
        ProcessContext init = this.getHost().getInitContext();
        Hashtable args = StringUtil.parse(this.getProcessEntry().getArguments(), 1, SuFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length > 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        String name = "root";
        if (tailArgs.length > 0) {
            name = tailArgs[0];
        }
        String pwd = null;
        if (tailArgs.length > 1) {
            pwd = tailArgs[1];
        }
        boolean login = args.get("-") != null;
        ProcessTableEntry pe = this.getParent().getProcessEntry();
        UID userID = u.find(name);
        if (!this.isPrivileged()) {
            u.authenticate(userID, pwd);
        }
        UserTableEntry ue = u.getEntry(userID);
        pe.setRealUserID(init, userID);
        pe.setEffectiveUserID(init, userID);
        pe.setRealGroupID(init, ue.getDefaultGroupID());
        pe.setEffectiveGroupID(init, ue.getDefaultGroupID());
        if (login) {
            pe.setMask(init, new Mask(2));
            f.getDirectoryNode(init, ue.getHome()).assertCanExecute(this.getParent());
            pe.setWorkingDirectory(init, ue.getHome());
            pe.setEnv(init, ue.getDefaultEnvironment());
        }
        this.kill();
    }
}

