/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import [Lcom.raplix.util.memix.commands.Command;;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.Commands;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.Processes;
import com.raplix.util.memix.users.Users;
import com.raplix.util.regex.REUtil;
import com.raplix.util.string.StringEscapedTokenizer;
import com.raplix.util.string.StringUtil;
import java.util.StringTokenizer;
import java.util.Vector;

public class SessionCommand
extends Command {
    private static final String CMD_DELIMITERS = ";" + StringUtil.LINE_SEPARATOR;
    private static final String ARG_DELIMITERS = " ";
    private static final String HOME_PREFIX = "~/";
    private static final String ARG_ESCAPES = "\\";
    public static final String ENV_PATH = "PATH";
    static /* synthetic */ Class array$Ljava$lang$String;

    public SessionCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        String[] args = this.getProcessEntry().getArguments();
        if (args.length != 1) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
    }

    public Command[] exec(String commands) throws Exception {
        FileSystem f = this.getHost().getFileSystem();
        Processes p = this.getHost().getProcesses();
        Commands c = this.getHost().getCommands();
        Users u = this.getHost().getUsers();
        StringTokenizer ct = new StringTokenizer(commands, CMD_DELIMITERS);
        Vector<Command> cCommands = new Vector<Command>();
        while (ct.hasMoreTokens()) {
            FID[] path;
            FID cmdID;
            int i;
            String command = ct.nextToken().trim();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Executing '" + command + "'", this);
            }
            StringEscapedTokenizer t = new StringEscapedTokenizer(command, ARG_DELIMITERS, ARG_ESCAPES);
            Vector<String> splitArgs = new Vector<String>();
            while (t.hasMoreTokens()) {
                String token = t.nextToken();
                if (token.startsWith(HOME_PREFIX)) {
                    splitArgs.addElement(u.getEntry(this.getUserID()).getHome().append(token.substring(HOME_PREFIX.length())).toString());
                    continue;
                }
                if (REUtil.compilePattern("\\*|\\?|\\[").match(token)) {
                    try {
                        FID[] IDs = f.expandGlob(this, new FID(token));
                        for (i = 0; i < IDs.length; ++i) {
                            splitArgs.addElement(IDs[i].toString());
                        }
                        continue;
                    }
                    catch (MemixIllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                splitArgs.addElement(token);
            }
            String[] args = (String[])CollectionUtil.mapClass(splitArgs, array$Ljava$lang$String == null ? SessionCommand.class$("[Ljava.lang.String;") : array$Ljava$lang$String);
            if (Logger.isDebugEnabled(this)) {
                StringBuffer buffer = new StringBuffer();
                for (i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        buffer.append(':');
                    }
                    buffer.append(args[i]);
                }
                Logger.debug("Processed '" + buffer + "'", this);
            }
            if ((cmdID = new FID(args[0])).isRelative() && (path = (FID[])this.getProcessEntry().getEnv(ENV_PATH)) != null) {
                Node node = null;
                for (int i2 = 0; i2 < path.length; ++i2) {
                    try {
                        node = f.getFileNode(this, path[i2].append(cmdID));
                        continue;
                    }
                    catch (MemixIllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                if (node == null) {
                    PackageInfo.throwUnknownCommand(args[0]);
                }
                args[0] = node.getFullFileID().toString();
            }
            PID processID = p.fork(this.getProcessID());
            Command cmd = c.exec(new ProcessContext(this, processID), args);
            if (!p.exists(processID)) continue;
            cCommands.addElement(cmd);
        }
        return (Command[])CollectionUtil.mapClass(cCommands, Command;.class);
    }
}

