/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.MountNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;

public class RmDirCommand
extends Command {
    public RmDirCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        FileSystem f = this.getHost().getFileSystem();
        String[] args = pe.getArguments();
        if (args.length < 2) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        for (int i = 1; i < args.length; ++i) {
            FID ID2 = new FID(args[i]);
            NodePointer pointer = f.split(this, ID2);
            Node node = f.getNode((ProcessContext)this, pointer, false);
            if (node instanceof MountNode) {
                PackageInfo.throwIsMount(ID2);
            }
            if (!(node instanceof DirectoryNode)) {
                com.raplix.util.memix.filesystem.PackageInfo.throwIsNotDirectory(ID2);
            }
            DirectoryNode parent = pointer.getParent();
            parent.removeChild(this, pointer.getID());
        }
        this.kill();
    }
}

