/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.commands.RmFactory;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.MountNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class RmCommand
extends Command {
    public RmCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private void rm(NodePointer pointer, boolean recursive) {
        FileSystem f = this.getHost().getFileSystem();
        DirectoryNode parent = pointer.getParent();
        Node node = f.getNode((ProcessContext)this, pointer, false);
        if (node instanceof MountNode) {
            PackageInfo.throwIsMount(pointer.getID());
        }
        if (recursive && node instanceof DirectoryNode) {
            DirectoryNode dn = (DirectoryNode)node;
            FID[] children = dn.getChildren(this);
            for (int i = 0; i < children.length; ++i) {
                if (children[i].equals(FID.ID_THIS) || children[i].equals(FID.ID_PARENT)) continue;
                this.rm(new NodePointer(dn, children[i]), recursive);
            }
        }
        parent.removeChild(this, pointer.getID());
    }

    public void run() {
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, RmFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 1) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean recursive = args.get("-R") != null;
        for (int i = 0; i < tailArgs.length; ++i) {
            FID ID2 = new FID(tailArgs[i]);
            NodePointer pointer = f.split(this, ID2);
            Node node = f.getNode((ProcessContext)this, pointer, false);
            if (!recursive && node instanceof DirectoryNode) {
                PackageInfo.throwIsDirectory(ID2);
            }
            this.rm(pointer, recursive);
        }
        this.kill();
    }
}

