/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.PrintUtil;
import com.raplix.util.memix.IDBase;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.commands.PsFactory;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.processes.Processes;
import com.raplix.util.memix.users.UID;
import com.raplix.util.string.StringUtil;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

public class PsCommand
extends Command {
    private static final int WIDTH = 5;

    public PsCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        Processes p = this.getHost().getProcesses();
        ProcessTableEntry pe = this.getProcessEntry();
        PrintWriter out = pe.getStdout();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, PsFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length != 0) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean longFormat = args.get("-l") != null;
        boolean every = args.get("-e") != null;
        boolean criteriaSet = false;
        UID realUserID = null;
        if (args.get("-U") != null) {
            realUserID = new UID(((String[])args.get("-U"))[0]);
            criteriaSet = true;
        }
        UID effectiveUserID = null;
        if (args.get("-u") != null) {
            effectiveUserID = new UID(((String[])args.get("-u"))[0]);
            criteriaSet = true;
        }
        GID realGroupID = null;
        if (args.get("-G") != null) {
            realGroupID = new GID(((String[])args.get("-G"))[0]);
            criteriaSet = true;
        }
        GID effectiveGroupID = null;
        if (args.get("-g") != null) {
            effectiveGroupID = new GID(((String[])args.get("-g"))[0]);
            criteriaSet = true;
        }
        Object[] IDs = p.getAll();
        Arrays.sort(IDs);
        if (longFormat) {
            PrintUtil.print(out, "UID", 2, 5, false);
            out.print(' ');
            PrintUtil.print(out, "RUID", 2, 5, false);
            out.print(' ');
            PrintUtil.print(out, "GID", 2, 5, false);
            out.print(' ');
            PrintUtil.print(out, "RGID", 2, 5, false);
            out.print(' ');
        }
        PrintUtil.print(out, "PID", 2, 5, false);
        out.println(" COMMAND");
        for (int i = 0; i < IDs.length; ++i) {
            ProcessTableEntry e = p.getEntry((PID)IDs[i]);
            if (!(every || !criteriaSet && e.getEffectiveUserID().equals(pe.getEffectiveUserID()) || realUserID != null && e.getRealUserID().equals(realUserID) || effectiveUserID != null && e.getEffectiveUserID().equals(effectiveUserID) || realGroupID != null && e.getRealGroupID().equals(realGroupID)) && (effectiveGroupID == null || !e.getEffectiveGroupID().equals(effectiveGroupID))) continue;
            if (longFormat) {
                PrintUtil.print(out, e.getEffectiveUserID().toString(), 2, 5, false);
                out.print(' ');
                PrintUtil.print(out, e.getRealUserID().toString(), 2, 5, false);
                out.print(' ');
                PrintUtil.print(out, e.getEffectiveGroupID().toString(), 2, 5, false);
                out.print(' ');
                PrintUtil.print(out, e.getRealGroupID().toString(), 2, 5, false);
                out.print(' ');
            }
            PrintUtil.print(out, ((IDBase)IDs[i]).toString(), 2, 5, false);
            String[] c = e.getArguments();
            for (int j = 0; j < c.length; ++j) {
                out.print(' ');
                out.print(c[j]);
            }
            out.println();
        }
        this.kill();
    }
}

