/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.message.MessageManager;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.memix.commands";
    public static final String EX_UNKNOWN_COMMAND = "util.memix.commands.EX_UNKNOWN_COMMAND";
    public static final String EX_MISSING_DATA = "util.memix.commands.EX_MISSING_DATA";
    public static final String EX_IS_MOUNT = "util.memix.commands.EX_IS_MOUNT";
    public static final String EX_IS_DIRECTORY = "util.memix.commands.EX_IS_DIRECTORY";
    public static final String EX_BAD_ARGUMENT_COUNT = "util.memix.commands.EX_BAD_ARGUMENT_COUNT";

    private PackageInfo() {
    }

    public static void throwUnknownCommand(String name) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_UNKNOWN_COMMAND, new Object[]{name}));
    }

    public static void throwMissingData(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_MISSING_DATA, new Object[]{ID2}));
    }

    public static void throwIsMount(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_IS_MOUNT, new Object[]{ID2}));
    }

    public static void throwIsDirectory(FID ID2) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_IS_DIRECTORY, new Object[]{ID2}));
    }

    public static void throwBadArgumentCount(int count) {
        throw new MemixIllegalArgumentException(MessageManager.messageAsString(EX_BAD_ARGUMENT_COUNT, new Object[]{new Integer(count)}));
    }
}

