/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.MountNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;

public class MvCommand
extends Command {
    public MvCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        FileSystem f = this.getHost().getFileSystem();
        String[] args = pe.getArguments();
        if (args.length < 3) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        int lastSource = args.length - 2;
        FID fullDstID = new FID(args[lastSource + 1]);
        DirectoryNode dstNode = null;
        if (lastSource == 1) {
            FID fullSrcID = new FID(args[1]);
            NodePointer srcPointer = f.split(this, fullSrcID);
            FID srcID = srcPointer.getID();
            Node srcNode = f.getNode((ProcessContext)this, srcPointer, false);
            NodePointer dstPointer = f.split(this, fullDstID);
            if (srcNode instanceof MountNode) {
                PackageInfo.throwIsMount(fullSrcID);
            }
            if (!f.exists(this, dstPointer)) {
                srcPointer.getParent().moveChild(this, srcID, dstPointer);
            } else {
                Node node = f.getNode((ProcessContext)this, dstPointer, false);
                if (node instanceof DirectoryNode) {
                    dstNode = (DirectoryNode)node;
                } else {
                    if (srcNode instanceof DirectoryNode) {
                        PackageInfo.throwIsDirectory(fullSrcID);
                    }
                    srcPointer.getParent().moveChild(this, srcID, dstPointer);
                }
            }
        } else {
            dstNode = f.getDirectoryNode(this, fullDstID);
        }
        if (dstNode != null) {
            for (int i = 1; i <= lastSource; ++i) {
                FID fullSrcID = new FID(args[i]);
                NodePointer srcPointer = f.split(this, fullSrcID);
                FID srcID = srcPointer.getID();
                Node srcNode = f.getNode((ProcessContext)this, srcPointer, false);
                if (srcNode instanceof MountNode) {
                    PackageInfo.throwIsMount(fullSrcID);
                }
                srcPointer.getParent().moveChild(this, srcID, new NodePointer(dstNode, srcID));
            }
        }
        this.kill();
    }
}

