/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.Host;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.MkUserFactory;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.Groups;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.Users;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class MkUserCommand
extends Command {
    public MkUserCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        Host h = this.getHost();
        FileSystem f = h.getFileSystem();
        Users u = h.getUsers();
        Groups g = h.getGroups();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, MkUserFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 1 || tailArgs.length > 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean privileged = args.get("-p") != null;
        String name = tailArgs[0];
        String pwd = null;
        if (tailArgs.length == 2) {
            pwd = tailArgs[1];
        }
        FID home = Host.DIR_HOME.append(name);
        DirectoryNode node = f.mkdir(this, home);
        GID groupID = privileged ? h.getPrivilegedGroupID() : h.getOtherGroupID();
        UID userID = u.create(this, name, pwd, home, groupID, new Hashtable());
        g.getEntry(groupID).addUser(this, userID);
        node.setUserID(this, userID);
        node.setGroupID(this, groupID);
        node.setMask(this, new Mask(493));
        this.kill();
    }
}

