/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.MkDirFactory;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class MkDirCommand
extends Command {
    public MkDirCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, MkDirFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 1) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean parents = args.get("-p") != null;
        Mask mode = null;
        if (args.get("-m") != null) {
            mode = new Mask(((String[])args.get("-m"))[0]);
        }
        for (int i = 0; i < tailArgs.length; ++i) {
            FID ID2 = new FID(tailArgs[i]);
            if (parents) {
                f.mkdirs(this, ID2);
            }
            DirectoryNode node = f.mkdir(this, ID2);
            if (mode == null) continue;
            node.setMask(this, mode);
        }
        this.kill();
    }
}

