/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.PrintUtil;
import com.raplix.util.memix.Host;
import com.raplix.util.memix.MemixIllegalArgumentException;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.LsFactory;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.groups.Groups;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.Users;
import com.raplix.util.string.StringUtil;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class LsCommand
extends Command {
    private static final char C_DIR = 'd';
    private static final char C_LINK = 'l';
    private static final char C_FILE = '-';
    private static final String RECENT_FORMAT = "MMM dd HH:mm";
    private static final String OLD_FORMAT = "MMM dd  yyyy";

    public LsCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private void assertDeadLinkPossible(MemixIllegalArgumentException ex) {
        String msg = ex.getMessage();
        if (msg != null && msg.indexOf("(025039)") != -1) {
            return;
        }
        throw ex;
    }

    private void list(Node node, boolean longFormat, long yearStart, FID ID2) {
        PrintWriter out = this.getProcessEntry().getStdout();
        Host h = this.getHost();
        Users u = h.getUsers();
        Groups g = h.getGroups();
        if (longFormat) {
            if (node instanceof DirectoryNode) {
                out.print('d');
            } else if (node instanceof LinkNode) {
                out.print('l');
            } else {
                out.print('-');
            }
            out.print(node.getMask());
            out.print(' ');
            String value = u.exists(node.getUserID()) ? u.getEntry(node.getUserID()).getName() : node.getUserID().toString();
            PrintUtil.print(out, value, 0, 8, false);
            out.print(' ');
            value = g.exists(node.getGroupID()) ? g.getEntry(node.getGroupID()).getName() : node.getGroupID().toString();
            PrintUtil.print(out, value, 0, 8, false);
            out.print(' ');
            PrintUtil.print(out, Long.toString(node.getSize()), 2, 10, false);
            out.print(' ');
            Date date = new Date(node.getModified());
            if (node.getModified() < yearStart) {
                out.print(new SimpleDateFormat(OLD_FORMAT).format(date));
            } else {
                out.print(new SimpleDateFormat(RECENT_FORMAT).format(date));
            }
            out.print(' ');
        }
        out.print(ID2);
        if (node instanceof LinkNode && longFormat) {
            out.print(" -> ");
            out.print(((LinkNode)node).getSource());
        }
        out.println();
    }

    public void run() {
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        PrintWriter out = pe.getStdout();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, LsFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length == 0) {
            tailArgs = new String[]{FID.ID_THIS.toString()};
        }
        boolean all = args.get("-a") != null;
        boolean followLinks = args.get("-L") != null;
        boolean longFormat = args.get("-l") != null;
        boolean recursive = args.get("-R") != null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long yearStart = cal.getTime().getTime();
        for (int i = 0; i < tailArgs.length; ++i) {
            Node node;
            FID path = new FID(tailArgs[i]);
            try {
                node = f.getNode((ProcessContext)this, path, followLinks);
            }
            catch (MemixIllegalArgumentException ex) {
                this.assertDeadLinkPossible(ex);
                node = f.getNode((ProcessContext)this, path, false);
            }
            if (!(node instanceof DirectoryNode)) {
                this.list(node, longFormat, yearStart, path);
                continue;
            }
            Stack<NodePointer> stack = new Stack<NodePointer>();
            stack.push(new NodePointer((DirectoryNode)node, path));
            while (stack.size() > 0) {
                int j;
                NodePointer pointer = (NodePointer)stack.pop();
                DirectoryNode dn = pointer.getParent();
                FID ID2 = pointer.getID();
                if (recursive || tailArgs.length > 1) {
                    out.print(ID2);
                    out.println(':');
                }
                Object[] children = dn.getChildren(this);
                Arrays.sort(children);
                Vector<NodePointer> recurse = new Vector<NodePointer>();
                for (j = 0; j < children.length; ++j) {
                    NodePointer np = new NodePointer(dn, (FID)children[j]);
                    try {
                        node = f.getNode((ProcessContext)this, np, followLinks);
                    }
                    catch (MemixIllegalArgumentException ex) {
                        this.assertDeadLinkPossible(ex);
                        node = f.getNode((ProcessContext)this, np, false);
                    }
                    if (all || !((FID)children[j]).isHidden()) {
                        this.list(node, longFormat, yearStart, (FID)children[j]);
                    }
                    if (!recursive || ((FID)children[j]).equals(FID.ID_THIS) || ((FID)children[j]).equals(FID.ID_PARENT) || !(node instanceof DirectoryNode)) continue;
                    recurse.addElement(new NodePointer((DirectoryNode)node, ID2.append((FID)children[j])));
                }
                for (j = recurse.size() - 1; j >= 0; --j) {
                    stack.push((NodePointer)recurse.get(j));
                }
                out.println();
            }
        }
        this.kill();
    }
}

