/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.UserTableEntry;
import com.raplix.util.memix.users.Users;

public class LoginCommand
extends Command {
    public LoginCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        FileSystem f = this.getHost().getFileSystem();
        Users u = this.getHost().getUsers();
        ProcessContext init = this.getHost().getInitContext();
        String[] args = this.getProcessEntry().getArguments();
        if (args.length < 2 || args.length > 3) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        String name = args[1];
        String pwd = null;
        if (args.length == 3) {
            pwd = args[2];
        }
        ProcessTableEntry pe = this.getParent().getProcessEntry();
        UID userID = u.find(name);
        u.authenticate(userID, pwd);
        UserTableEntry ue = u.getEntry(userID);
        pe.setRealUserID(init, userID);
        pe.setEffectiveUserID(init, userID);
        pe.setRealGroupID(init, ue.getDefaultGroupID());
        pe.setEffectiveGroupID(init, ue.getDefaultGroupID());
        pe.setMask(init, new Mask(2));
        f.getDirectoryNode(init, ue.getHome()).assertCanExecute(this.getParent());
        pe.setWorkingDirectory(init, ue.getHome());
        pe.setEnv(init, ue.getDefaultEnvironment());
        this.kill();
    }
}

