/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.LnFactory;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class LnCommand
extends Command {
    public LnCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        FID dstPath;
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, LnFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 1 || tailArgs.length > 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean parents = args.get("-p") != null;
        FID srcPath = new FID(tailArgs[0]);
        FID[] srcPathComp = srcPath.split();
        if (srcPathComp.length < 1) {
            if (tailArgs.length == 1) {
                PackageInfo.throwBadArgumentCount(tailArgs.length);
            }
            dstPath = new FID(tailArgs[1]);
            if (parents) {
                f.mkdirs(this, dstPath);
            }
        } else {
            FID srcName = srcPathComp[srcPathComp.length - 1];
            if (tailArgs.length == 1) {
                dstPath = srcName;
                if (parents) {
                    f.mkdirs(this, dstPath);
                }
            } else {
                NodePointer dstPointer;
                dstPath = new FID(tailArgs[1]);
                if (parents) {
                    f.mkdirs(this, dstPath);
                }
                if (f.exists(this, dstPointer = f.split(this, dstPath))) {
                    dstPath = dstPath.append(srcName);
                }
            }
        }
        f.ln(this, dstPath, srcPath);
        this.kill();
    }
}

