/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.Groups;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.Users;
import java.io.PrintWriter;

public class IdCommand
extends Command {
    public IdCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private void showUserID(PrintWriter out, String label, UID ID2) {
        Users u = this.getHost().getUsers();
        out.print(label);
        out.print('=');
        out.print(ID2);
        if (u.exists(ID2)) {
            out.print('(');
            out.print(u.getEntry(ID2).getName());
            out.print(')');
        }
    }

    private void showGroupID(PrintWriter out, String label, GID ID2) {
        Groups g = this.getHost().getGroups();
        out.print(label);
        out.print('=');
        out.print(ID2);
        if (g.exists(ID2)) {
            out.print('(');
            out.print(g.getEntry(ID2).getName());
            out.print(')');
        }
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        PrintWriter out = pe.getStdout();
        String[] args = pe.getArguments();
        if (args.length != 1) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        this.showUserID(out, "uid", pe.getRealUserID());
        out.print(' ');
        this.showGroupID(out, "gid", pe.getRealGroupID());
        if (!pe.getRealUserID().equals(pe.getEffectiveUserID())) {
            out.print(' ');
            this.showUserID(out, "euid", pe.getEffectiveUserID());
        }
        if (!pe.getRealGroupID().equals(pe.getEffectiveGroupID())) {
            out.print(' ');
            this.showGroupID(out, "egid", pe.getRealGroupID());
        }
        out.println();
        this.kill();
    }
}

