/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.PrintUtil;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import java.io.PrintWriter;

public class DuCommand
extends Command {
    public DuCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private long du(Node node, FID ID2) {
        PrintWriter out = this.getProcessEntry().getStdout();
        long size = node.getMount().getDrive().getBlocks(node.getSize());
        if (!(node instanceof DirectoryNode)) {
            return size;
        }
        DirectoryNode dn = (DirectoryNode)node;
        FID[] children = dn.getChildren(this);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].equals(FID.ID_THIS) || children[i].equals(FID.ID_PARENT)) continue;
            size += this.du(dn.getChild(this, children[i]), ID2.append(children[i]));
        }
        PrintUtil.print(out, Long.toString(size), 0, 7, false);
        out.println(ID2);
        return size;
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        FileSystem f = this.getHost().getFileSystem();
        String[] args = pe.getArguments();
        if (args.length == 1) {
            args = new String[2];
            args[1] = FID.ID_THIS.toString();
        }
        for (int i = 1; i < args.length; ++i) {
            FID ID2 = new FID(args[i]);
            this.du(f.getNode((ProcessContext)this, ID2, false), ID2);
        }
        this.kill();
    }
}

