/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.CpFactory;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class CpCommand
extends Command {
    public CpCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void cp(Node srcNode, NodePointer dstPointer, boolean recursive) {
        FileSystem f = this.getHost().getFileSystem();
        Node dstNode = null;
        if (f.exists(this, dstPointer)) {
            dstNode = f.getNode((ProcessContext)this, dstPointer, true);
        }
        if (srcNode instanceof DirectoryNode) {
            DirectoryNode dstDir;
            if (!recursive) {
                PackageInfo.throwIsDirectory(srcNode.getFullFileID());
            }
            DirectoryNode srcDir = (DirectoryNode)srcNode;
            if (dstNode != null) {
                if (!(dstNode instanceof DirectoryNode)) {
                    com.raplix.util.memix.filesystem.PackageInfo.throwIsNotDirectory(dstNode.getFullFileID());
                }
                dstDir = (DirectoryNode)dstNode;
                dstDir.assertIsNotDescendant(srcDir);
            } else {
                dstPointer.getParent().assertIsNotDescendant(srcDir);
                dstDir = FileSystem.mkdir(this, dstPointer);
            }
            FID[] children = srcDir.getChildren(this);
            for (int i = 0; i < children.length; ++i) {
                if (children[i].equals(FID.ID_THIS) || children[i].equals(FID.ID_PARENT)) continue;
                NodePointer srcChild = new NodePointer(srcDir, children[i]);
                NodePointer dstChild = new NodePointer(dstDir, children[i]);
                this.cp(f.getNode((ProcessContext)this, srcChild, true), dstChild, recursive);
            }
            return;
        }
        if (dstNode == null) {
            dstNode = FileSystem.creat(this, dstPointer);
        }
        dstNode.setSize(this, srcNode.getSize());
        dstNode.setCustom(srcNode.getCustom());
    }

    public void run() {
        ProcessTableEntry pe = this.getProcessEntry();
        FileSystem f = this.getHost().getFileSystem();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, CpFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        boolean recursive = args.get("-R") != null;
        int lastSource = tailArgs.length - 2;
        FID fullDstID = new FID(tailArgs[lastSource + 1]);
        DirectoryNode dstNode = null;
        if (lastSource == 0) {
            NodePointer srcPointer = f.split(this, new FID(tailArgs[0]));
            Node srcNode = f.getNode((ProcessContext)this, srcPointer, true);
            NodePointer dstPointer = f.split(this, fullDstID);
            if (!f.exists(this, dstPointer)) {
                this.cp(srcNode, dstPointer, recursive);
            } else {
                Node node = f.getNode((ProcessContext)this, dstPointer, true);
                if (node instanceof DirectoryNode) {
                    dstNode = (DirectoryNode)node;
                } else {
                    this.cp(srcNode, dstPointer, recursive);
                }
            }
        } else {
            dstNode = f.getDirectoryNode(this, fullDstID);
        }
        if (dstNode != null) {
            for (int i = 0; i <= lastSource; ++i) {
                NodePointer srcPointer = f.split(this, new FID(tailArgs[i]));
                Node srcNode = f.getNode((ProcessContext)this, srcPointer, true);
                this.cp(srcNode, new NodePointer(dstNode, srcPointer.getID()), recursive);
            }
        }
        this.kill();
    }
}

