/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.exceptions.ExceptionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.AddUserFactory;
import com.raplix.util.memix.commands.CatFactory;
import com.raplix.util.memix.commands.CdFactory;
import com.raplix.util.memix.commands.ChGrpFactory;
import com.raplix.util.memix.commands.ChModFactory;
import com.raplix.util.memix.commands.ChOwnFactory;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.CommandFactory;
import com.raplix.util.memix.commands.CpFactory;
import com.raplix.util.memix.commands.DuFactory;
import com.raplix.util.memix.commands.GroupsFactory;
import com.raplix.util.memix.commands.IdFactory;
import com.raplix.util.memix.commands.KillFactory;
import com.raplix.util.memix.commands.LnFactory;
import com.raplix.util.memix.commands.LoginFactory;
import com.raplix.util.memix.commands.LogoutFactory;
import com.raplix.util.memix.commands.LsFactory;
import com.raplix.util.memix.commands.MkDirFactory;
import com.raplix.util.memix.commands.MkGrpFactory;
import com.raplix.util.memix.commands.MkUserFactory;
import com.raplix.util.memix.commands.MvFactory;
import com.raplix.util.memix.commands.NewGrpFactory;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.commands.PsFactory;
import com.raplix.util.memix.commands.PwdFactory;
import com.raplix.util.memix.commands.RmDirFactory;
import com.raplix.util.memix.commands.RmFactory;
import com.raplix.util.memix.commands.SessionFactory;
import com.raplix.util.memix.commands.SuFactory;
import com.raplix.util.memix.commands.TouchFactory;
import com.raplix.util.memix.commands.UnZipFactory;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.ProcessTableEntry;

public class Commands {
    public static final String CUSTOM_IMPL = "implementation";

    public void register(ProcessContext context, CommandFactory factory, FID ID2) {
        NodePointer pointer;
        FileSystem f = context.getHost().getFileSystem();
        Node node = f.exists(context, pointer = f.split(context, ID2)) ? f.getNode(context, pointer, true) : FileSystem.creat(context, pointer);
        node.setCustom(CUSTOM_IMPL, factory);
        node.setMask(context, node.getMask().augment(73));
    }

    public void registerInternal(ProcessContext context) {
        this.register(context, new AddUserFactory(), AddUserFactory.FILE_ID);
        this.register(context, new CatFactory(), CatFactory.FILE_ID);
        this.register(context, new CdFactory(), CdFactory.FILE_ID);
        this.register(context, new ChGrpFactory(), ChGrpFactory.FILE_ID);
        this.register(context, new ChModFactory(), ChModFactory.FILE_ID);
        this.register(context, new ChOwnFactory(), ChOwnFactory.FILE_ID);
        this.register(context, new CpFactory(), CpFactory.FILE_ID);
        this.register(context, new DuFactory(), DuFactory.FILE_ID);
        this.register(context, new GroupsFactory(), GroupsFactory.FILE_ID);
        this.register(context, new IdFactory(), IdFactory.FILE_ID);
        this.register(context, new KillFactory(), KillFactory.FILE_ID);
        this.register(context, new LnFactory(), LnFactory.FILE_ID);
        this.register(context, new LoginFactory(), LoginFactory.FILE_ID);
        this.register(context, new LogoutFactory(), LogoutFactory.FILE_ID);
        this.register(context, new LsFactory(), LsFactory.FILE_ID);
        this.register(context, new MkDirFactory(), MkDirFactory.FILE_ID);
        this.register(context, new MkGrpFactory(), MkGrpFactory.FILE_ID);
        this.register(context, new MkUserFactory(), MkUserFactory.FILE_ID);
        this.register(context, new MvFactory(), MvFactory.FILE_ID);
        this.register(context, new NewGrpFactory(), NewGrpFactory.FILE_ID);
        this.register(context, new PsFactory(), PsFactory.FILE_ID);
        this.register(context, new PwdFactory(), PwdFactory.FILE_ID);
        this.register(context, new RmFactory(), RmFactory.FILE_ID);
        this.register(context, new RmDirFactory(), RmDirFactory.FILE_ID);
        this.register(context, new SessionFactory(), SessionFactory.FILE_ID);
        this.register(context, new SuFactory(), SuFactory.FILE_ID);
        this.register(context, new TouchFactory(), TouchFactory.FILE_ID);
        this.register(context, new UnZipFactory(), UnZipFactory.FILE_ID);
    }

    public String help(ProcessContext context, FID ID2) {
        FileNode node = context.getHost().getFileSystem().getFileNode(context, ID2);
        node.assertCanExecute(context);
        CommandFactory factory = (CommandFactory)node.getCustom(CUSTOM_IMPL);
        if (factory == null) {
            return null;
        }
        return factory.getHelp();
    }

    public Command exec(ProcessContext context, String[] args) throws Exception {
        CommandFactory factory;
        if (args.length < 1) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Executing '" + args[0] + "'", this);
        }
        FileSystem f = context.getHost().getFileSystem();
        ProcessTableEntry pe = context.getProcessEntry();
        FileNode node = f.getFileNode(context, new FID(args[0]));
        node.assertCanExecute(context);
        pe.setArguments(context, args);
        if (node.getMask().isSetUID()) {
            pe.setEffectiveUserID(context, node.getUserID());
        }
        if (node.getMask().isSetGID()) {
            pe.setEffectiveGroupID(context, node.getGroupID());
        }
        if ((factory = (CommandFactory)node.getCustom(CUSTOM_IMPL)) == null) {
            return null;
        }
        Command cmd = factory.getCommand(context.getParent(), context.getProcessID());
        try {
            cmd.run();
        }
        catch (Throwable t) {
            cmd.kill();
            ExceptionUtil.rethrow(t);
        }
        return cmd;
    }
}

