/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.Host;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.ChOwnFactory;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.Groups;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.Users;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class ChOwnCommand
extends Command {
    public ChOwnCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private void chown(Node node, boolean recursive, UID userID, GID groupID) {
        FileSystem f = this.getHost().getFileSystem();
        if (node instanceof LinkNode) {
            recursive = false;
            node = f.getNode((ProcessContext)this, new NodePointer(null, node.getFullFileID()), true);
        }
        if (userID != null) {
            node.setUserID(this, userID);
        }
        if (groupID != null) {
            node.setGroupID(this, groupID);
        }
        if (!recursive || !(node instanceof DirectoryNode)) {
            return;
        }
        DirectoryNode dn = (DirectoryNode)node;
        FID[] children = dn.getChildren(this);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].equals(FID.ID_THIS) || children[i].equals(FID.ID_PARENT)) continue;
            this.chown(dn.getChild(this, children[i]), recursive, userID, groupID);
        }
    }

    public void run() {
        Host h = this.getHost();
        FileSystem f = h.getFileSystem();
        Users u = h.getUsers();
        Groups g = h.getGroups();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, ChOwnFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        String ug = tailArgs[0];
        int index = ug.indexOf(58);
        UID userID = null;
        GID groupID = null;
        if (index == -1) {
            userID = u.find(ug);
        } else {
            if (index != 0) {
                userID = u.find(ug.substring(0, index));
            }
            groupID = g.find(ug.substring(index + 1));
        }
        boolean recursive = args.get("-R") != null;
        for (int i = 1; i < tailArgs.length; ++i) {
            this.chown(f.getNode((ProcessContext)this, new FID(tailArgs[i]), false), recursive, userID, groupID);
        }
        this.kill();
    }
}

