/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.ChModFactory;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class ChModCommand
extends Command {
    public ChModCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private void chmod(Node node, boolean recursive, String mode) {
        FileSystem f = this.getHost().getFileSystem();
        if (node instanceof LinkNode) {
            recursive = false;
            node = f.getNode((ProcessContext)this, new NodePointer(null, node.getFullFileID()), true);
        }
        node.setMask(this, node.getMask().chmod(this, mode));
        if (!recursive || !(node instanceof DirectoryNode)) {
            return;
        }
        DirectoryNode dn = (DirectoryNode)node;
        FID[] children = dn.getChildren(this);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].equals(FID.ID_THIS) || children[i].equals(FID.ID_PARENT)) continue;
            this.chmod(dn.getChild(this, children[i]), recursive, mode);
        }
    }

    public void run() {
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, ChModFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        String mode = tailArgs[0];
        boolean recursive = args.get("-R") != null;
        for (int i = 1; i < tailArgs.length; ++i) {
            this.chmod(f.getNode((ProcessContext)this, new FID(tailArgs[i]), false), recursive, mode);
        }
        this.kill();
    }
}

