/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.Host;
import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.ChGrpFactory;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.LinkNode;
import com.raplix.util.memix.filesystem.Node;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.Groups;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;

public class ChGrpCommand
extends Command {
    public ChGrpCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    private void chgrp(Node node, boolean recursive, GID groupID) {
        FileSystem f = this.getHost().getFileSystem();
        if (node instanceof LinkNode) {
            recursive = false;
            node = f.getNode((ProcessContext)this, new NodePointer(null, node.getFullFileID()), true);
        }
        node.setGroupID(this, groupID);
        if (!recursive || !(node instanceof DirectoryNode)) {
            return;
        }
        DirectoryNode dn = (DirectoryNode)node;
        FID[] children = dn.getChildren(this);
        for (int i = 0; i < children.length; ++i) {
            if (children[i].equals(FID.ID_THIS) || children[i].equals(FID.ID_PARENT)) continue;
            this.chgrp(dn.getChild(this, children[i]), recursive, groupID);
        }
    }

    public void run() {
        Host h = this.getHost();
        FileSystem f = h.getFileSystem();
        Groups g = h.getGroups();
        ProcessTableEntry pe = this.getProcessEntry();
        Hashtable args = StringUtil.parse(pe.getArguments(), 1, ChGrpFactory.ARGS);
        String[] tailArgs = (String[])args.get("untagged");
        if (tailArgs.length < 2) {
            PackageInfo.throwBadArgumentCount(tailArgs.length);
        }
        GID groupID = g.find(tailArgs[0]);
        boolean recursive = args.get("-R") != null;
        for (int i = 1; i < tailArgs.length; ++i) {
            this.chgrp(f.getNode((ProcessContext)this, new FID(tailArgs[i]), false), recursive, groupID);
        }
        this.kill();
    }
}

