/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.Users;

public class CdCommand
extends Command {
    public CdCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() {
        Users u = this.getHost().getUsers();
        FileSystem f = this.getHost().getFileSystem();
        ProcessTableEntry pe = this.getProcessEntry();
        String[] args = pe.getArguments();
        if (args.length < 1 || args.length > 2) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        FID path = args.length == 2 ? new FID(args[1]) : u.getEntry(this.getUserID()).getHome();
        DirectoryNode node = f.getDirectoryNode(this, path);
        node.assertCanExecute(this);
        this.getParent().getProcessEntry().setWorkingDirectory(this, node.getFullFileID());
        this.kill();
    }
}

