/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.commands;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Command;
import com.raplix.util.memix.commands.PackageInfo;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileNode;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class CatCommand
extends Command {
    public CatCommand(ProcessContext parent, PID processID) {
        super(parent, processID);
    }

    public void run() throws IOException {
        ProcessTableEntry pe = this.getProcessEntry();
        PrintWriter out = pe.getStdout();
        FileSystem f = this.getHost().getFileSystem();
        String[] args = pe.getArguments();
        if (args.length < 2) {
            PackageInfo.throwBadArgumentCount(args.length);
        }
        for (int i = 1; i < args.length; ++i) {
            FID ID2 = new FID(args[i]);
            FileNode node = f.getFileNode(this, ID2);
            File file = (File)node.getCustom("data");
            if (file == null) {
                PackageInfo.throwMissingData(ID2);
            }
            FileReader reader = new FileReader(file);
            while (reader.ready()) {
                out.write(reader.read());
            }
            reader.close();
        }
        this.kill();
    }
}

