/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix.aix;

import com.raplix.util.logger.Logger;
import com.raplix.util.memix.aix.AixFileSystem;
import com.raplix.util.memix.aix.DfFactory;
import com.raplix.util.memix.filesystem.Drive;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.posix.PosixHost;
import com.raplix.util.platform.aix.StatVFS;
import java.util.Hashtable;

public class AixHost
extends PosixHost {
    private Hashtable mDriveMap = new Hashtable();

    public AixHost(String name, String root) {
        this.init(name, root, "/", new AixFileSystem());
        this.getCommands().register(this.getInitContext(), new DfFactory(), DfFactory.FILE_ID);
    }

    public Hashtable getDriveMap() {
        return this.mDriveMap;
    }

    public Drive createDrive(String name, FID ID2) {
        StatVFS s;
        try {
            s = new StatVFS(name);
        }
        catch (IllegalArgumentException ex) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Status check on '" + name + "': " + ex.getMessage(), this);
            }
            return null;
        }
        Long driveID = new Long(s.getFSID());
        Mount mount = (Mount)this.getDriveMap().get(driveID);
        if (mount != null) {
            return null;
        }
        Drive drive = new Drive("S" + driveID, s.getFrSize(), s.getBlocks(), s.getBFree());
        this.mDriveMap.put(driveID, new Mount(name, ID2, drive));
        return drive;
    }

    public static class Mount {
        private String mName;
        private FID mID;
        private Drive mDrive;

        public Mount(String name, FID ID2, Drive drive) {
            this.mName = name;
            this.mID = ID2;
            this.mDrive = drive;
        }

        public String getName() {
            return this.mName;
        }

        public FID getID() {
            return this.mID;
        }

        public Drive getDrive() {
            return this.mDrive;
        }
    }
}

