/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix;

import com.raplix.util.memix.Host;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.ProcessTableEntry;
import com.raplix.util.memix.users.UID;

public class ProcessContext {
    private ProcessContext mParent;
    private Host mHost;
    private PID mProcessID;

    ProcessContext(Host host, PID processID) {
        this.mHost = host;
        this.mProcessID = processID;
    }

    public ProcessContext(ProcessContext parent, PID processID) {
        this.mParent = parent;
        this.mHost = parent.getHost();
        this.mProcessID = processID;
    }

    public Host getHost() {
        return this.mHost;
    }

    public PID getProcessID() {
        return this.mProcessID;
    }

    public ProcessTableEntry getProcessEntry() {
        return this.getHost().getProcesses().getEntry(this.getProcessID());
    }

    public ProcessContext getParent() {
        return this.mParent;
    }

    public PID getParentID() {
        return this.getParent().getProcessID();
    }

    public UID getUserID() {
        return this.getProcessEntry().getEffectiveUserID();
    }

    public GID getGroupID() {
        return this.getProcessEntry().getEffectiveGroupID();
    }

    public boolean isUser(UID ID2) {
        return this.getUserID().equals(ID2);
    }

    public boolean isGroup(GID ID2) {
        return this.getGroupID().equals(ID2);
    }

    public boolean isPrivileged() {
        return this.isInGroup(this.getHost().getPrivilegedGroupID());
    }

    public boolean isInGroup(GID ID2) {
        return this.getHost().getGroups().getEntry(ID2).containsUser(this.getUserID());
    }
}

