/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.memix;

import com.raplix.util.memix.ProcessContext;
import com.raplix.util.memix.commands.Commands;
import com.raplix.util.memix.commands.LoginFactory;
import com.raplix.util.memix.commands.SessionCommand;
import com.raplix.util.memix.commands.SessionFactory;
import com.raplix.util.memix.filesystem.DirectoryNode;
import com.raplix.util.memix.filesystem.Drive;
import com.raplix.util.memix.filesystem.ExternalFileSystem;
import com.raplix.util.memix.filesystem.FID;
import com.raplix.util.memix.filesystem.FileSystem;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.memix.filesystem.NodePointer;
import com.raplix.util.memix.groups.ExternalGroups;
import com.raplix.util.memix.groups.GID;
import com.raplix.util.memix.groups.Groups;
import com.raplix.util.memix.processes.PID;
import com.raplix.util.memix.processes.Processes;
import com.raplix.util.memix.users.ExternalUsers;
import com.raplix.util.memix.users.UID;
import com.raplix.util.memix.users.Users;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;

public class Host {
    private static final String DIGEST = "SHA";
    private static final String DRIVE_NAME = "SystemDrive";
    private static final long DRIVE_CAPACITY = 0L;
    private static final long DRIVE_BLOCK_SIZE = 4096L;
    public static final String ROOT_USER_NAME = "root";
    public static final String ROOT_USER_PWD = "proot";
    public static final String ROOT_GROUP_NAME = "root";
    public static final String ROOT_GROUP_PWD = "proot";
    public static final String OTHER_GROUP_NAME = "other";
    public static final String OTHER_GROUP_PWD = null;
    public static final String ENV_HOST = "HOST";
    public static final FID DIR_TMP = FID.ID_ROOT.append("tmp");
    public static final FID DIR_HOME = FID.ID_ROOT.append("home");
    public static final FID DIR_USR = FID.ID_ROOT.append("usr");
    public static final FID DIR_USR_BIN = DIR_USR.append("bin");
    public static final FID DIR_BIN = FID.ID_ROOT.append("bin");
    private static final FID[] PATH_ROOT = new FID[]{DIR_BIN, DIR_USR_BIN};
    private String mName;
    private MessageDigest mDigest;
    private PrintWriter mConsoleStdout;
    private PrintWriter mConsoleStderr;
    private Commands mCommands;
    private UID mRootUserID;
    private GID mRootGroupID;
    private GID mOtherGroupID;
    private Processes mProcesses;
    private Groups mGroups;
    private Users mUsers;
    private Drive mSystemDrive;
    private FileSystem mFileSystem;
    private ProcessContext mInitContext;

    protected Host() {
    }

    public Host(String name) {
        this.init(name, null, null, null);
    }

    protected void init(String name, ExternalUsers externalUsers, ExternalGroups externalGroups, ExternalFileSystem externalFileSystem) {
        this.mName = name;
        try {
            this.mDigest = MessageDigest.getInstance(DIGEST);
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        this.mConsoleStdout = new PrintWriter(System.out);
        this.mConsoleStderr = new PrintWriter(System.err);
        this.mCommands = new Commands();
        this.mProcesses = new Processes();
        this.mGroups = new Groups(this.getDigest(), externalGroups);
        this.mUsers = new Users(this.getDigest(), externalUsers);
        this.mRootGroupID = this.getGroups().create(null, "root", "proot");
        this.mOtherGroupID = this.getGroups().create(null, OTHER_GROUP_NAME, OTHER_GROUP_PWD);
        Hashtable<String, FID[]> userEnv = new Hashtable<String, FID[]>();
        userEnv.put("PATH", PATH_ROOT);
        this.mRootUserID = this.getUsers().create(null, "root", "proot", FID.ID_ROOT, this.getPrivilegedGroupID(), userEnv);
        this.getGroups().getEntry(this.getPrivilegedGroupID()).addUser(null, this.getPrivilegedUserID());
        this.mSystemDrive = new Drive(DRIVE_NAME, 4096L, 0L, 0L);
        if (externalFileSystem == null) {
            this.mFileSystem = new FileSystem(new Mask(493), this.getPrivilegedUserID(), this.getPrivilegedGroupID(), this.mSystemDrive);
        } else {
            externalFileSystem.init(this);
            this.mFileSystem = new FileSystem(externalFileSystem);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(ENV_HOST, this.getName());
        PID initID = this.getProcesses().create(this.getPrivilegedUserID(), this.getPrivilegedUserID(), this.getPrivilegedGroupID(), this.getPrivilegedGroupID(), new String[]{"init"}, this.getConsoleStdout(), this.getConsoleStderr(), new Mask(0), FID.ID_ROOT, env);
        this.mInitContext = new ProcessContext(this, initID);
        this.mkdirIfNew(DIR_TMP, "1777");
        this.mkdirIfNew(DIR_HOME, "555");
        this.mkdirIfNew(DIR_USR, "755");
        this.mkdirIfNew(DIR_USR_BIN, "755");
        this.lnIfNew(DIR_BIN, DIR_USR_BIN);
        this.getCommands().registerInternal(this.getInitContext());
    }

    private void mkdirIfNew(FID ID2, String mask) {
        NodePointer pointer;
        ProcessContext c = this.getInitContext();
        FileSystem f = this.getFileSystem();
        if (!f.exists(c, pointer = f.split(c, ID2))) {
            DirectoryNode node = FileSystem.mkdir(c, pointer);
            node.setMask(c, new Mask(mask));
        }
    }

    private void lnIfNew(FID ID2, FID source) {
        NodePointer pointer;
        ProcessContext c = this.getInitContext();
        FileSystem f = this.getFileSystem();
        if (!f.exists(c, pointer = f.split(c, ID2))) {
            FileSystem.ln(c, pointer, source);
        }
    }

    public String getName() {
        return this.mName;
    }

    public MessageDigest getDigest() {
        return this.mDigest;
    }

    public PrintWriter getConsoleStdout() {
        return this.mConsoleStdout;
    }

    public PrintWriter getConsoleStderr() {
        return this.mConsoleStderr;
    }

    public Commands getCommands() {
        return this.mCommands;
    }

    public Users getUsers() {
        return this.mUsers;
    }

    public Groups getGroups() {
        return this.mGroups;
    }

    public Processes getProcesses() {
        return this.mProcesses;
    }

    public Drive getSystemDrive() {
        return this.mSystemDrive;
    }

    public FileSystem getFileSystem() {
        return this.mFileSystem;
    }

    public UID getPrivilegedUserID() {
        return this.mRootUserID;
    }

    public GID getPrivilegedGroupID() {
        return this.mRootGroupID;
    }

    public GID getOtherGroupID() {
        return this.mOtherGroupID;
    }

    public ProcessContext getInitContext() {
        return this.mInitContext;
    }

    public SessionCommand getRootSession(String shell) throws Exception {
        PID sessionID = this.getProcesses().fork(this.getInitContext().getProcessID());
        ProcessContext context = new ProcessContext(this.getInitContext(), sessionID);
        SessionCommand session = null;
        session = (SessionCommand)this.getCommands().exec(context, new String[]{shell});
        session.exec(LoginFactory.FILE_ID.toString() + " " + "root" + " " + "proot");
        return session;
    }

    public SessionCommand getRootSession() throws Exception {
        return this.getRootSession(SessionFactory.FILE_ID.toString());
    }
}

