/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.mail;

import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Email {
    private String mTo;
    private String mCC;
    private String mBCC;
    private String mFrom;
    private String mSubject;
    private String mBody;
    private String mMailServer;
    private int mMailPort;
    private String mMailerName = this.lookupMailerName();
    private Properties mProps = null;
    private Session mSession;
    private MimeMessage mMessage;
    private static final int DEFAULT_SMTP_PORT = 25;
    private static final String MSG_DEFAULT_MAILER = "util.mail.MAILER_NAME";
    private static final String MSG_INVALID_PORT = "util.mail.INVALID_PORT";
    private static final String MSG_CANNOT_SEND_EMAIL = "util.mail.CANT_SEND_EMAIL";
    private static final String MSG_NO_RECIPIENTS = "util.mail.NO_RECIPIENTS";
    private static final String MSG_NO_RETURN_ADDRESS = "util.mail.NO_RETURN_ADDRESS";
    private static final String MSG_NO_BODY = "util.mail.NO_BODY";
    private static final String MSG_NO_SERVER = "util.mail.NO_SERVER";
    private static final String EMAIL_ENCODING = "UTF-8";
    private static final String MAILER_PROPERTY = "X-MAILER";

    private String lookupMailerName() {
        return MessageManager.messageAsString(MSG_DEFAULT_MAILER);
    }

    public void setTo(String inTo) {
        this.mTo = inTo;
    }

    public String getTo() {
        return this.mTo;
    }

    public void setCC(String inCC) {
        this.mCC = inCC;
    }

    public String getCC() {
        return this.mCC;
    }

    public void setBCC(String inBCC) {
        this.mBCC = inBCC;
    }

    public String getBCC() {
        return this.mBCC;
    }

    public void setFrom(String inFrom) {
        this.mFrom = inFrom;
    }

    public String getFrom() {
        return this.mFrom;
    }

    public void setSubject(String inSubject) {
        this.mSubject = inSubject;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public void setBody(String inBody) {
        this.mBody = inBody;
    }

    public String getBody() {
        return this.mBody;
    }

    public void setMailServer(String inMailServer) {
        this.setMailServer(inMailServer, 25);
    }

    public void setMailServer(String inMailServer, int inMailPort) throws IllegalArgumentException {
        if (inMailPort <= 0 || inMailPort > 65535) {
            String msg = MessageManager.messageAsString(MSG_INVALID_PORT, new Object[]{new Integer(inMailPort)});
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, this);
            }
            throw new IllegalArgumentException(msg);
        }
        this.mMailServer = inMailServer;
        this.mMailPort = inMailPort;
    }

    public String getMailServer() {
        return this.mMailServer;
    }

    public int getMailPort() {
        return this.mMailPort;
    }

    public void setMailerName(String inMailerName) {
        this.mMailerName = inMailerName;
    }

    public String getMailerName() {
        return this.mMailerName;
    }

    public boolean getDebug() {
        return Logger.isDebugEnabled(this);
    }

    public void send() throws IllegalStateException {
        this.validate();
        try {
            this.constructEmail();
            this.sendEmail();
        }
        catch (MessagingException me) {
            String msg = MessageManager.messageAsString(MSG_CANNOT_SEND_EMAIL);
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, me, this);
            }
            throw new RuntimeException(msg);
        }
    }

    protected void validate() throws IllegalStateException {
        if (null == this.mTo || 0 == this.mTo.length()) {
            String msg = MessageManager.messageAsString(MSG_NO_RECIPIENTS);
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, this);
            }
            throw new IllegalStateException(msg);
        }
        if (null == this.mFrom || 0 == this.mFrom.length()) {
            String msg = MessageManager.messageAsString(MSG_NO_RETURN_ADDRESS);
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, this);
            }
            throw new IllegalStateException(msg);
        }
        if (null == this.mBody || 0 == this.mBody.length()) {
            String msg = MessageManager.messageAsString(MSG_NO_BODY);
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, this);
            }
            throw new IllegalStateException(msg);
        }
        if (null == this.mMailServer || 0 == this.mMailServer.length()) {
            String msg = MessageManager.messageAsString(MSG_NO_SERVER);
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg, this);
            }
            throw new IllegalStateException(msg);
        }
    }

    protected void constructEmail() throws MessagingException {
        this.mProps = System.getProperties();
        this.mProps.put("mail.smtp.host", this.getMailServer());
        this.mSession = Session.getDefaultInstance((Properties)this.mProps, null);
        this.mMessage = new MimeMessage(this.mSession);
        this.mMessage.setFrom((Address)new InternetAddress(this.getFrom()));
        this.mMessage.setRecipients(Message.RecipientType.TO, (Address[])Email.parseInternetAddress(this.getTo()));
        if (this.getCC() != null) {
            this.mMessage.setRecipients(Message.RecipientType.CC, (Address[])Email.parseInternetAddress(this.getCC()));
        }
        if (this.getBCC() != null) {
            this.mMessage.setRecipients(Message.RecipientType.BCC, (Address[])Email.parseInternetAddress(this.getBCC()));
        }
        if (this.getSubject() != null) {
            this.mMessage.setSubject(this.getSubject());
        }
        if (this.getBody() != null) {
            this.mMessage.setText(this.getBody(), EMAIL_ENCODING);
        }
        this.mMessage.setHeader(MAILER_PROPERTY, this.getMailerName());
        this.mMessage.setSentDate(new Date());
    }

    public static InternetAddress[] parseInternetAddress(String addressList) throws AddressException {
        return InternetAddress.parse((String)addressList.replace(';', ','), (boolean)true);
    }

    protected void sendEmail() throws MessagingException {
        this.mSession.setDebug(this.getDebug());
        Transport.send((Message)this.mMessage);
    }
}

