/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.logger;

import com.raplix.util.message.MessageManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;

public class Logger {
    public static final String DEFAULT_LOGGER_FILE_NAME = "logger_config.xml";
    public static final String DEFAULT_LOGGER_FILE_CLASSPATH_LOCATION = "/config";

    public static void initializeLoggingSystem() {
        BasicConfigurator.configure();
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getRootLogger();
        log4jLogger.setLevel(Level.ERROR);
        Logger.preLoadMessages();
    }

    public static void initializeLoggingSystem(String configFilePath, long watchDelaySeconds) {
        try {
            if (watchDelaySeconds > 0L) {
                long watchDelayMS = watchDelaySeconds * 1000L;
                DOMConfigurator.configureAndWatch((String)configFilePath, (long)watchDelayMS);
            } else {
                DOMConfigurator.configure((String)configFilePath);
            }
        }
        catch (Exception e) {
            System.err.println("Warning.  Could not load logger config file: " + configFilePath + " using defaults");
        }
        Logger.preLoadMessages();
    }

    private static void preLoadMessages() {
        MessageManager.messageAsString("messageNotFound");
    }

    public static void debug(String msg, Object inCategory) {
        Logger.getCategory(inCategory).debug((Object)msg);
    }

    public static void debug(String msg, Throwable t, Object inCategory) {
        Logger.getCategory(inCategory).debug((Object)msg, t);
    }

    public static void info(String msg, Object inCategory) {
        Logger.getCategory(inCategory).info((Object)msg);
    }

    public static void info(String msg, Throwable t, Object inCategory) {
        Logger.getCategory(inCategory).info((Object)msg, t);
    }

    public static void warn(String msg, Object inCategory) {
        Logger.getCategory(inCategory).warn((Object)msg);
    }

    public static void warn(String msg, Throwable t, Object inCategory) {
        Logger.getCategory(inCategory).warn((Object)msg, t);
    }

    public static void error(String msg, Object inCategory) {
        Logger.getCategory(inCategory).error((Object)msg);
    }

    public static void error(String msg, Throwable t, Object inCategory) {
        Logger.getCategory(inCategory).error((Object)msg, t);
    }

    public static void log(String callerFQCN, Priority priority, String msg, Throwable t, Object inCategory) {
        Logger.getCategory(inCategory).log(callerFQCN, priority, (Object)msg, t);
    }

    public static void log(String callerFQCN, Priority priority, String msg, Object inCategory) {
        Logger.getCategory(inCategory).log(callerFQCN, priority, (Object)msg, null);
    }

    private static Category getCategory(Object inCategory) {
        Category cat = null;
        String catName = "";
        if (inCategory == null) {
            inCategory = "";
        }
        catName = inCategory instanceof String ? (String)inCategory : (inCategory instanceof Class ? ((Class)inCategory).getName() : inCategory.getClass().getName());
        try {
            cat = Category.getInstance((String)catName);
        }
        catch (NullPointerException npe) {
            cat = Category.getInstance((String)"");
        }
        return cat;
    }

    public static boolean isDebugEnabled(Object inCategory) {
        return Logger.getCategory(inCategory).isDebugEnabled();
    }

    public static boolean isInfoEnabled(Object inCategory) {
        return Logger.getCategory(inCategory).isInfoEnabled();
    }

    public static boolean isWarnEnabled(Object inCategory) {
        return Logger.getCategory(inCategory).isEnabledFor(Priority.WARN);
    }

    public static boolean isErrorEnabled(Object inCategory) {
        return Logger.getCategory(inCategory).isEnabledFor(Priority.ERROR);
    }

    static {
        Logger.initializeLoggingSystem();
    }
}

