/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.locks;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.graphs.ADEdge;
import com.raplix.util.graphs.ADVertex;
import com.raplix.util.graphs.CycleAnalysis;
import com.raplix.util.graphs.DFSVertexInfo;
import com.raplix.util.graphs.DVertex;
import com.raplix.util.locks.DeadlockCycle;
import com.raplix.util.locks.DeadlockException;
import com.raplix.util.locks.LockManager;
import com.raplix.util.locks.LockableInfo;
import com.raplix.util.locks.Locker;
import com.raplix.util.locks.PackageInfo;
import com.raplix.util.locks.QueuedLocker;
import java.util.Vector;

public class LockerInfo {
    private Locker mLocker;
    private LockableInfo mQueue;
    private LockManager mManager;
    private ADVertex mVertex;
    private ADEdge mEdge;
    static /* synthetic */ Class array$Lcom$raplix$util$locks$QueuedLocker;

    public LockerInfo(Locker locker) {
        this.mLocker = locker;
    }

    private void addEdge() {
        this.mEdge = new ADEdge(this.mVertex, this.mQueue.getOwnerInfo().mVertex, (Object)this.mQueue);
        this.mManager.getGraph().addEdge(this.mEdge);
    }

    private void removeEdge() {
        this.mManager.getGraph().removeEdge(this.mEdge);
        this.mEdge = null;
    }

    void setManager(LockManager manager) {
        if (this.mManager != null) {
            return;
        }
        this.mManager = manager;
        this.mVertex = new ADVertex(this);
        this.mManager.getGraph().addVertex(this.mVertex);
    }

    public void destroy() {
        if (this.mManager == null) {
            return;
        }
        this.mManager.getGraph().removeVertex(this.mVertex);
        this.mManager = null;
    }

    Locker getLocker() {
        return this.mLocker;
    }

    void acquired() {
        this.addEdge();
    }

    void released() {
        this.removeEdge();
    }

    void enqueued(LockableInfo lockableInfo) throws DeadlockException {
        this.mQueue = lockableInfo;
        this.mQueue.enqueued(this);
        if (!this.mQueue.isOwned()) {
            return;
        }
        this.addEdge();
        CycleAnalysis analysis = new CycleAnalysis(this.mManager.getGraph());
        if (!analysis.hasCycle()) {
            return;
        }
        this.dequeued();
        DFSVertexInfo[] cIn = analysis.getBackEdges();
        DeadlockCycle[] cOut = new DeadlockCycle[cIn.length];
        for (int i = 0; i < cIn.length; ++i) {
            DFSVertexInfo edge = cIn[i];
            DVertex lastVertex = edge.getVertex();
            Vector<QueuedLocker> lockers = new Vector<QueuedLocker>();
            while (true) {
                DFSVertexInfo next = edge.getParentVertex();
                lockers.addElement(new QueuedLocker(((LockerInfo)((ADVertex)next.getVertex()).getData()).getLocker(), ((LockableInfo)((ADEdge)edge.getParentEdge()).getData()).getLockable()));
                if (next.getVertex().equals(lastVertex)) break;
                edge = next;
            }
            cOut[i] = new DeadlockCycle((QueuedLocker[])CollectionUtil.mapClass(lockers, array$Lcom$raplix$util$locks$QueuedLocker == null ? LockerInfo.class$("[Lcom.raplix.util.locks.QueuedLocker;") : array$Lcom$raplix$util$locks$QueuedLocker));
        }
        throw PackageInfo.createDeadlockDetected(cOut);
    }

    void dequeued() {
        this.mQueue.dequeued(this);
        this.mQueue = null;
        if (this.mEdge != null) {
            this.removeEdge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }
}

