/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.locks;

import com.raplix.util.locks.Lockable;
import com.raplix.util.locks.LockerInfo;
import java.util.HashSet;
import java.util.Iterator;

public class LockableInfo {
    private Lockable mLockable;
    private LockerInfo mOwnerInfo;
    private HashSet mQueue = new HashSet();

    public LockableInfo(Lockable lockable) {
        this.mLockable = lockable;
    }

    Lockable getLockable() {
        return this.mLockable;
    }

    boolean isOwned() {
        return this.mOwnerInfo != null;
    }

    LockerInfo getOwnerInfo() {
        return this.mOwnerInfo;
    }

    void acquired(LockerInfo lockerInfo) {
        this.mOwnerInfo = lockerInfo;
        Iterator i = this.mQueue.iterator();
        while (i.hasNext()) {
            ((LockerInfo)i.next()).acquired();
        }
    }

    void released() {
        Iterator i = this.mQueue.iterator();
        while (i.hasNext()) {
            ((LockerInfo)i.next()).released();
        }
        this.mOwnerInfo = null;
    }

    void enqueued(LockerInfo lockerInfo) {
        this.mQueue.add(lockerInfo);
    }

    void dequeued(LockerInfo lockerInfo) {
        this.mQueue.remove(lockerInfo);
    }
}

