/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.locks;

import com.raplix.util.graphs.ADGraph;
import com.raplix.util.locks.DeadlockException;
import com.raplix.util.locks.Lockable;
import com.raplix.util.locks.Locker;

public class LockManager {
    private ADGraph mGraph = new ADGraph(this);

    ADGraph getGraph() {
        return this.mGraph;
    }

    public boolean isEmpty() {
        return this.getGraph().getVertices().length == 0 && this.getGraph().getEdges().length == 0;
    }

    public void acquired(Locker locker, Lockable lockable) {
        lockable.getInfo().acquired(locker.getInfo());
    }

    public void released(Lockable lockable) {
        lockable.getInfo().released();
    }

    public void enqueued(Locker locker, Lockable lockable) throws DeadlockException {
        locker.getInfo().setManager(this);
        locker.getInfo().enqueued(lockable.getInfo());
    }

    public void dequeued(Locker locker) {
        locker.getInfo().dequeued();
    }
}

