/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.junit;

import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Compare;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.windows.WindowsServices;
import com.raplix.util.regex.REUtil;
import com.raplix.util.string.StringUtil;
import junit.framework.TestCase;

public class TestBase
extends TestCase {
    public TestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (PlatformUtil.isWin32()) {
            WindowsServices.getInstance();
        }
    }

    private static void notify(String prefix, String message) {
        if (prefix == null) {
            TestBase.fail((String)message);
        } else {
            TestBase.fail((String)(prefix + ": " + message));
        }
    }

    public static void assertREMatch(String message, String expected, String actual) {
        String newExp = expected;
        String newAct = actual;
        if (expected.endsWith("$")) {
            newExp = expected.substring(0, expected.length() - 1) + "a$";
            newAct = newAct + "a";
        }
        if (!REUtil.compilePattern(newExp).match(newAct)) {
            TestBase.notify(message, "Expected <" + actual + "> to match <" + expected + ">");
        }
    }

    public static void assertREMatch(String expected, String actual) {
        TestBase.assertREMatch(null, expected, actual);
    }

    public static void assertREMismatch(String message, String expected, String actual) {
        String newExp = expected;
        String newAct = actual;
        if (expected.endsWith("$")) {
            newExp = expected.substring(0, expected.length() - 1) + "a$";
            newAct = newAct + "a";
        }
        if (REUtil.compilePattern(newExp).match(newAct)) {
            TestBase.notify(message, "Expected <" + actual + "> to not match <" + expected + ">");
        }
    }

    public static void assertREMismatch(String expected, String actual) {
        TestBase.assertREMismatch(null, expected, actual);
    }

    public static void assertCollectionEquals(String message, Object expected, Object actual) {
        if (!Compare.isEqual(expected, actual)) {
            TestBase.notify(message, "Expected <" + CollectionUtil.toString(actual) + ">" + StringUtil.LINE_SEPARATOR + "to equal <" + CollectionUtil.toString(expected) + ">");
        }
    }

    public static void assertCollectionEquals(Object expected, Object actual) {
        TestBase.assertCollectionEquals(null, expected, actual);
    }

    public static void assertCollectionNotEquals(String message, Object expected, Object actual) {
        if (Compare.isEqual(expected, actual)) {
            TestBase.notify(message, "Expected <" + CollectionUtil.toString(actual) + "> to have a value other than <" + CollectionUtil.toString(expected) + ">");
        }
    }

    public static void assertCollectionNotEquals(Object expected, Object actual) {
        TestBase.assertCollectionNotEquals(null, expected, actual);
    }

    public static void assertPermutation(String message, Object expected, Object actual) {
        if (!Compare.isPermutation(expected, actual)) {
            TestBase.notify(message, "Expected <" + CollectionUtil.toString(actual) + ">" + StringUtil.LINE_SEPARATOR + "to be permutation of <" + CollectionUtil.toString(expected) + ">");
        }
    }

    public static void assertPermutation(Object expected, Object actual) {
        TestBase.assertPermutation(null, expected, actual);
    }

    public static void assertNotPermutation(String message, Object expected, Object actual) {
        if (Compare.isPermutation(expected, actual)) {
            TestBase.notify(message, "Expected <" + CollectionUtil.toString(actual) + ">" + StringUtil.LINE_SEPARATOR + "to not be permutation of <" + CollectionUtil.toString(expected) + ">");
        }
    }

    public static void assertNotPermutation(Object expected, Object actual) {
        TestBase.assertNotPermutation(null, expected, actual);
    }

    public static void assertContains(String message, Object collection, Object element) {
        if (Compare.indexOf(collection, element) == -1) {
            TestBase.notify(message, "Expected <" + CollectionUtil.toString(collection) + ">" + StringUtil.LINE_SEPARATOR + "to contain <" + element + ">");
        }
    }

    public static void assertContains(Object collection, Object element) {
        TestBase.assertContains(null, collection, element);
    }

    public static void assertNotContains(String message, Object collection, Object element) {
        if (Compare.indexOf(collection, element) != -1) {
            TestBase.notify(message, "Expected <" + CollectionUtil.toString(collection) + ">" + StringUtil.LINE_SEPARATOR + "to not contain <" + element + ">");
        }
    }

    public static void assertNotContains(Object collection, Object element) {
        TestBase.assertNotContains(null, collection, element);
    }
}

