/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.junit;

import com.raplix.util.junit.TestConstraint;
import com.raplix.util.platform.common.PlatformUtil;

public abstract class PlatformTestConstraint
implements TestConstraint {
    private boolean mIsEmpty = true;
    private boolean mMatchCurrentPlatform = false;

    public PlatformTestConstraint addSolaris() {
        this.updateCurrentPlatform(PlatformUtil.isSolaris());
        return this;
    }

    public PlatformTestConstraint addSolarisX86() {
        this.updateCurrentPlatform(PlatformUtil.isSolarisX86());
        return this;
    }

    public PlatformTestConstraint addSolarisSparc() {
        this.updateCurrentPlatform(PlatformUtil.isSolarisSparc());
        return this;
    }

    public PlatformTestConstraint addLinux32() {
        this.updateCurrentPlatform(PlatformUtil.isLinux32());
        return this;
    }

    public PlatformTestConstraint addLinux64() {
        this.updateCurrentPlatform(PlatformUtil.isLinux64());
        return this;
    }

    public PlatformTestConstraint addAix() {
        this.updateCurrentPlatform(PlatformUtil.isAix());
        return this;
    }

    public PlatformTestConstraint addLinux() {
        this.updateCurrentPlatform(PlatformUtil.isLinux());
        return this;
    }

    public PlatformTestConstraint addLinuxSles() {
        this.updateCurrentPlatform(PlatformUtil.isLinuxSles());
        return this;
    }

    public PlatformTestConstraint addHpux() {
        this.updateCurrentPlatform(PlatformUtil.isHpux());
        return this;
    }

    public PlatformTestConstraint addLinuxRedHat() {
        this.updateCurrentPlatform(PlatformUtil.isLinuxRedHat());
        return this;
    }

    public PlatformTestConstraint addCygwin() {
        this.updateCurrentPlatform(PlatformUtil.isCygwin());
        return this;
    }

    public PlatformTestConstraint addUnix() {
        this.updateCurrentPlatform(PlatformUtil.isUnix());
        return this;
    }

    public PlatformTestConstraint addPosix() {
        this.updateCurrentPlatform(PlatformUtil.isPOSIX());
        return this;
    }

    public PlatformTestConstraint addWin2k() {
        this.updateCurrentPlatform(PlatformUtil.isWin2k());
        return this;
    }

    public PlatformTestConstraint addWin2k3() {
        this.updateCurrentPlatform(PlatformUtil.isWin2k3());
        return this;
    }

    public PlatformTestConstraint addWinXP() {
        this.updateCurrentPlatform(PlatformUtil.isWinXP());
        return this;
    }

    public PlatformTestConstraint addWin32() {
        this.updateCurrentPlatform(PlatformUtil.isWin32());
        return this;
    }

    public PlatformTestConstraint addPureWin32() {
        this.updateCurrentPlatform(PlatformUtil.isPureWin32());
        return this;
    }

    protected boolean currentPlatform() {
        return this.mMatchCurrentPlatform;
    }

    protected boolean isEmpty() {
        return this.mIsEmpty;
    }

    private void updateCurrentPlatform(boolean isCurrentPlatform) {
        this.mIsEmpty = false;
        this.mMatchCurrentPlatform = this.mMatchCurrentPlatform || isCurrentPlatform;
    }
}

