/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.junit;

import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.unicode.Encoding;
import com.raplix.util.unicode.EncodingRepository;
import com.raplix.util.unicode.EncodingTranslator;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Random;

public class I18n {
    protected static final Random rand = new Random(new Date().getTime());
    protected static Locale[] sLocales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.FRENCH, Locale.KOREAN, Locale.JAPANESE, new Locale("es", "ES"), Locale.GERMAN};

    public static String addBOM(String inString) throws UnsupportedEncodingException {
        return I18n.addBOM(inString, Encoding.UTF8.getName());
    }

    public static String addBOM(String inString, String inEncoding) throws UnsupportedEncodingException {
        Encoding e = EncodingRepository.getGlobalInstance().find(inEncoding);
        if (null == e) {
            throw new UnsupportedEncodingException();
        }
        return new String(e.getSignature(), e.getName()) + inString;
    }

    public static String generateNativeString() throws UnsupportedEncodingException {
        return I18n.generateNativeString(Math.abs(rand.nextInt() % 255) + 1);
    }

    public static String generateNativeString(int length) throws UnsupportedEncodingException {
        if (length <= 0) {
            return null;
        }
        String encoding = System.getProperty("file.encoding");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(I18n.generateLetter(encoding));
        }
        return new String(buffer.toString().getBytes(encoding), encoding);
    }

    public static String generateUnicodeString() {
        return I18n.generateUnicodeString(Math.abs(rand.nextInt() % 255) + 1);
    }

    public static String generateUnicodeNumber() {
        return I18n.generateUnicodeNumber(Math.abs(rand.nextInt() % 20) + 1);
    }

    public static String generateUnicodeAlnum() {
        return I18n.generateUnicodeAlnum(Math.abs(rand.nextInt() % 254) + 2);
    }

    public static String generateUnicodeSequence() {
        return I18n.generateUnicodeSequence(Math.abs(rand.nextInt() % 255) + 1);
    }

    public static String generateUnicodeString(int length) {
        if (length <= 0) {
            return null;
        }
        return I18n.generateString(length);
    }

    public static String generateUnicodeNumber(int length) {
        if (length <= 0) {
            return null;
        }
        return I18n.generateNumber(length);
    }

    public static String generateUnicodeAlnum(int length) {
        if (length <= 0) {
            return null;
        }
        String result = I18n.generateString(1);
        if (length > 1) {
            result = result + I18n.generateNumber(1);
        }
        if (length > 2) {
            result = result + I18n.generateAlnum(length - 2);
        }
        return result;
    }

    public static String generateUnicodeSequence(int length) {
        if (length <= 0) {
            return null;
        }
        return I18n.generateSequence(length);
    }

    protected static String generateString(int length) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(I18n.generateLetter());
        }
        return buffer.toString();
    }

    protected static String generateNumber(int length) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(I18n.generateNumber());
        }
        return buffer.toString();
    }

    protected static String generateAlnum(int length) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(I18n.generateAlnum());
        }
        return buffer.toString();
    }

    protected static String generateSequence(int length) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(I18n.generateSequenceCharacter());
        }
        return buffer.toString();
    }

    protected static Character generateLetter() {
        Character c = I18n.generateCharacter();
        while (!Character.isLetter(c.charValue())) {
            c = I18n.generateCharacter();
        }
        return c;
    }

    protected static Character generateLetter(String inEncoding) throws UnsupportedEncodingException {
        String encoding = EncodingTranslator.translate(inEncoding);
        Character c = null;
        while (c == null || !Character.isLetter(c.charValue())) {
            if (encoding.equals("646") || encoding.equals("ISO646-US") || encoding.equals("ANSI_X3.4-1968")) {
                c = I18n.generateCharacter(0, 127);
                continue;
            }
            if (encoding.equals("ISO-8859-1") || encoding.equals("ISO8859_1") || encoding.equals("Cp1252") || encoding.equals("ISO8859-1")) {
                c = I18n.generateCharacter(0, 255);
                continue;
            }
            if (encoding.equals("UTF-8") || encoding.equals("UTF8")) {
                c = I18n.generateLetter();
                continue;
            }
            if (encoding.equals("GB2312")) {
                c = I18n.generateCharacter(12544, 12591);
                continue;
            }
            if (encoding.equals("BIG5")) {
                c = I18n.generateCharacter(63744, 64255);
                continue;
            }
            if (encoding.equals("EUC-KR")) {
                c = I18n.generateCharacter(12592, 12687);
                continue;
            }
            if (encoding.equals("EUC-JP")) {
                c = I18n.generateCharacter(12352, 12447);
                continue;
            }
            throw new UnsupportedEncodingException("Cannot create a string for encoding " + encoding);
        }
        return c;
    }

    protected static Character generateNumber() {
        Character c = I18n.generateCharacter();
        while (!Character.isDigit(c.charValue())) {
            c = I18n.generateCharacter();
        }
        return c;
    }

    protected static Character generateAlnum() {
        Character c = I18n.generateCharacter();
        while (!Character.isLetterOrDigit(c.charValue())) {
            c = I18n.generateCharacter();
        }
        return c;
    }

    protected static Character generateSequenceCharacter() {
        Character c = I18n.generateCharacter();
        while (!Character.isDefined(c.charValue()) || Character.isISOControl(c.charValue()) || I18n.isNotSuitedToCurrentPlatform(c.charValue())) {
            c = I18n.generateCharacter();
        }
        return c;
    }

    protected static Character generateCharacter() {
        return I18n.generateCharacter(1, 65535);
    }

    protected static Character generateCharacter(int inBeginRange, int inEndRange) {
        return new Character((char)(Math.abs(rand.nextInt() % (inEndRange - inBeginRange + 1)) + inBeginRange));
    }

    public static void main(String[] args) {
        System.out.println("Using encoding " + System.getProperty("file.encoding"));
        try {
            String nativeStr = I18n.generateNativeString(10);
            System.out.println(nativeStr);
            byte[] b = nativeStr.getBytes();
            for (int i = 0; i < b.length; ++i) {
                System.out.print((b[i] < 0 ? b[i] + 256 : b[i]) + " ");
            }
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e);
        }
    }

    public static boolean isNotSuitedToCurrentPlatform(char c) {
        if (PlatformUtil.isSolaris()) {
            return I18n.isHighSurrogate(c) || I18n.isLowSurrogate(c);
        }
        if (PlatformUtil.isLinux()) {
            return I18n.isHighSurrogate(c) || I18n.isLowSurrogate(c);
        }
        if (PlatformUtil.isHpux()) {
            return I18n.isHighSurrogate(c) || I18n.isLowSurrogate(c);
        }
        if (PlatformUtil.isWin32()) {
            return I18n.isHighSurrogate(c) || I18n.isLowSurrogate(c);
        }
        if (PlatformUtil.isAix()) {
            return I18n.isHighSurrogate(c) || I18n.isLowSurrogate(c);
        }
        return false;
    }

    protected static boolean isHighSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    protected static boolean isLowSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static Locale getRandomLocale() {
        return sLocales[Math.abs(rand.nextInt() % sLocales.length)];
    }

    public static void setRandomLocale() {
        Locale.setDefault(I18n.getRandomLocale());
        System.out.println("Test using locale " + Locale.getDefault() + " with encoding " + System.getProperty("file.encoding"));
    }

    public static String byteString(String inString) {
        byte[] b;
        try {
            b = inString.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buffer.append(b[i] < 0 ? b[i] + 256 : b[i]).append(' ');
        }
        return buffer.toString();
    }

    public static class PostgresCCollationStringComparator
    implements Comparator {
        private boolean mIsAscending;
        private boolean mUsesAscii;

        public PostgresCCollationStringComparator(boolean inAscending) {
            this.mIsAscending = inAscending;
            this.mUsesAscii = true;
        }

        private int doAsciiCompare(char c1, char c2, boolean toUpperCase) {
            if (toUpperCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 >= '[' && c1 <= '`' && c2 >= 'a' && c2 <= 'z') {
                return -1;
            }
            if (c2 >= '[' && c2 <= '`' && c1 >= 'a' && c1 <= 'z') {
                return 1;
            }
            return new Character(c1).compareTo(new Character(c2));
        }

        private int doCompare(String s1, String s2, boolean toUpperCase) {
            byte[] bytes2;
            byte[] bytes1;
            try {
                bytes1 = s1.getBytes("UTF8");
                bytes2 = s2.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < bytes1.length; ++i) {
                if (i > bytes2.length) {
                    return 1;
                }
                if (bytes1[i] < 127 && bytes2[i] < 127) {
                    int rc = this.doAsciiCompare((char)bytes1[i], (char)bytes2[i], toUpperCase);
                    if (rc == 0) continue;
                    return rc;
                }
                this.mUsesAscii = false;
                if (bytes1[i] < bytes2[i]) {
                    return 1;
                }
                if (bytes1[i] <= bytes2[i]) continue;
                return -1;
            }
            if (bytes2.length > bytes1.length) {
                return -1;
            }
            return 0;
        }

        public int compare(Object o1, Object o2) {
            int rc = this.doCompare((String)o1, (String)o2, true);
            if (rc == 0 && this.mUsesAscii) {
                rc = this.doCompare((String)o1, (String)o2, false);
            }
            return this.mIsAscending ? rc : rc * -1;
        }
    }
}

