/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.junit;

import com.raplix.util.junit.TestConstraint;
import com.raplix.util.platform.common.PlatformUtil;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ConstrainedTestSuite
extends TestSuite {
    private TestConstraint mSuiteConstraint;
    private Hashtable mConstraintTable = new Hashtable();
    private static final TestConstraint NULL_CONSTRAINT = new NullConstraint();

    public ConstrainedTestSuite() {
    }

    public ConstrainedTestSuite(Class theClass) {
        super(theClass);
    }

    public ConstrainedTestSuite(String name) {
        super(name);
    }

    public ConstrainedTestSuite(TestConstraint suiteConstraint) {
        this.mSuiteConstraint = suiteConstraint;
    }

    public ConstrainedTestSuite(Class theClass, TestConstraint suiteConstraint) {
        super(theClass);
        this.mSuiteConstraint = suiteConstraint;
    }

    public ConstrainedTestSuite(String name, TestConstraint suiteConstraint) {
        super(name);
        this.mSuiteConstraint = suiteConstraint;
    }

    public void setTestConstraint(String testName, TestConstraint testConstraint) {
        this.mConstraintTable.put(testName, testConstraint);
    }

    public void addTest(TestCase test, TestConstraint testConstraint) {
        this.addTest((Test)test);
        this.setTestConstraint(test.getName(), testConstraint);
    }

    public void runTest(Test test, TestResult result) {
        if (this.getTestConstraint(test).shouldRunTest(test)) {
            super.runTest(test, result);
        } else {
            super.runTest(this.disabledTest(test), result);
        }
    }

    public void setSuiteConstraint(TestConstraint suiteConstraint) {
        this.mSuiteConstraint = suiteConstraint;
    }

    private TestConstraint getTestConstraint(Test test) {
        TestConstraint returnValue;
        if (test instanceof TestCase && (returnValue = (TestConstraint)this.mConstraintTable.get(((TestCase)test).getName())) != null) {
            return returnValue;
        }
        return this.mSuiteConstraint != null ? this.mSuiteConstraint : NULL_CONSTRAINT;
    }

    private Test disabledTest(Test test) {
        String name = test instanceof TestCase ? ((TestCase)test).getName() : test.toString();
        name = ConstrainedTestSuite.getDisabledTestName(name);
        return new DisabledTestCase(name);
    }

    public static String getDisabledTestName(String name) {
        StringBuffer sb = new StringBuffer(name);
        sb.append("_DISABLED_").append(PlatformUtil.OS_NAME);
        for (int i = 0; i < sb.length(); ++i) {
            if (Character.isJavaIdentifierPart(sb.charAt(i))) continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    private static class DisabledTestCase
    extends TestCase {
        DisabledTestCase(String name) {
            super(name);
        }

        protected void runTest() {
        }
    }

    private static class NullConstraint
    implements TestConstraint {
        private NullConstraint() {
        }

        public boolean shouldRunTest(Test test) {
            return true;
        }
    }
}

