/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.iowrappers.Closable;
import com.raplix.util.iowrappers.Names;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class WriterWrapper
implements Closable,
Names {
    private Writer mWriter;
    private boolean mStandard;

    public WriterWrapper(String name) throws IOException {
        if ("-".equals(name)) {
            this.mWriter = new OutputStreamWriter(System.out);
            this.mStandard = true;
        } else if ("-:".equals(name)) {
            this.mWriter = new OutputStreamWriter(System.err);
            this.mStandard = true;
        } else {
            this.mStandard = false;
            if (name.startsWith("+")) {
                this.mWriter = new FileWriter(name.substring("+".length()), true);
            } else {
                this.init(new File(name));
            }
        }
    }

    public WriterWrapper(File file) throws IOException {
        this.init(file);
    }

    public WriterWrapper(Writer writer, boolean standard) {
        this.mWriter = writer;
        this.mStandard = standard;
    }

    public WriterWrapper(Writer writer) {
        this(writer, false);
    }

    private void init(File file) throws IOException {
        this.mStandard = false;
        this.mWriter = new FileWriter(file);
    }

    public Writer getWriter() {
        return this.mWriter;
    }

    public boolean getStandard() {
        return this.mStandard;
    }

    public synchronized void close() throws IOException {
        if (this.mWriter == null) {
            return;
        }
        if (this.getStandard()) {
            this.mWriter.flush();
        } else {
            this.mWriter.close();
        }
        this.mWriter = null;
    }
}

