/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.file.FileUtil;
import com.raplix.util.iowrappers.Closable;
import java.io.File;
import java.io.IOException;

public class TempFile
implements Closable {
    private static String sDefaultPrefix = "raplix";
    private static String sDefaultSuffix = ".tmp";
    private File mFile;

    public TempFile(String prefix, String suffix) throws IOException {
        this.mFile = File.createTempFile(prefix, suffix);
    }

    public TempFile(String prefix) throws IOException {
        this(prefix, sDefaultSuffix);
    }

    public TempFile() throws IOException {
        this(sDefaultPrefix, sDefaultSuffix);
    }

    public TempFile(File file) {
        this.mFile = file;
    }

    public File getFile() {
        return this.mFile;
    }

    public static String getDefaultPrefix() {
        return sDefaultPrefix;
    }

    public static void setDefaultPrefix(String prefix) {
        sDefaultPrefix = prefix;
    }

    public static String getDefaultSuffix() {
        return sDefaultSuffix;
    }

    public static void setDefaultSuffix(String suffix) {
        sDefaultSuffix = suffix;
    }

    public synchronized void close() throws IOException {
        if (this.mFile == null) {
            return;
        }
        FileUtil.ensureDeleted(this.mFile);
        this.mFile = null;
    }
}

