/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.iowrappers.Closable;
import com.raplix.util.iowrappers.Names;
import com.raplix.util.unicode.UnicodeFileReader;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;

public class ReaderWrapper
implements Closable,
Names {
    private Reader mReader;
    private boolean mStandard;

    public ReaderWrapper(String name) throws FileNotFoundException, IOException {
        if ("-".equals(name)) {
            this.mReader = new UnicodeInputStreamReader(System.in);
            this.mStandard = true;
        } else {
            this.init(new File(name));
        }
    }

    public ReaderWrapper(File file) throws FileNotFoundException {
        this.init(file);
    }

    public ReaderWrapper(Reader reader, boolean standard) {
        this.mReader = reader;
        this.mStandard = standard;
    }

    public ReaderWrapper(Reader reader) {
        this(reader, false);
    }

    private void init(File file) throws FileNotFoundException {
        this.mStandard = false;
        this.mReader = new UnicodeFileReader(file);
    }

    public Reader getReader() {
        return this.mReader;
    }

    public boolean getStandard() {
        return this.mStandard;
    }

    public synchronized void close() throws IOException {
        if (this.mReader == null) {
            return;
        }
        if (!this.getStandard()) {
            this.mReader.close();
        }
        this.mReader = null;
    }
}

