/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.iowrappers.Closable;
import com.raplix.util.string.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Stack;

public class PrefixWrapper
implements Closable {
    private PrintWriter mWriter;
    private String mDef;
    private Stack mPrefixes = new Stack();
    private boolean mNewLine = true;

    public PrefixWrapper(PrintWriter writer, String def) {
        this.mWriter = writer;
        this.mDef = def;
    }

    private void printPrefixes() {
        if (!this.mNewLine) {
            return;
        }
        Enumeration e = this.mPrefixes.elements();
        while (e.hasMoreElements()) {
            this.mWriter.print(e.nextElement());
        }
        this.mNewLine = false;
    }

    public void push(String prefix) {
        this.mPrefixes.push(prefix);
    }

    public void push(int spaces) {
        this.mPrefixes.push(StringUtil.repeat(" ", spaces));
    }

    public void pushDefault() {
        this.push(this.mDef);
    }

    public void pop() {
        this.mPrefixes.pop();
    }

    public void print(boolean b) {
        this.printPrefixes();
        this.mWriter.print(b);
    }

    public void print(char c) {
        this.printPrefixes();
        this.mWriter.print(c);
    }

    public void print(char[] s) {
        this.printPrefixes();
        this.mWriter.print(s);
    }

    public void print(double d) {
        this.printPrefixes();
        this.mWriter.print(d);
    }

    public void print(float f) {
        this.printPrefixes();
        this.mWriter.print(f);
    }

    public void print(int i) {
        this.printPrefixes();
        this.mWriter.print(i);
    }

    public void print(long l) {
        this.printPrefixes();
        this.mWriter.print(l);
    }

    public void print(Object obj) {
        this.printPrefixes();
        this.mWriter.print(obj);
    }

    public void print(String s) {
        this.printPrefixes();
        this.mWriter.print(s);
    }

    public void println() {
        this.printPrefixes();
        this.mWriter.println();
        this.mNewLine = true;
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char[] s) {
        this.print(s);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(Object obj) {
        this.print(obj);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public synchronized void close() throws IOException {
        if (this.mWriter == null) {
            return;
        }
        this.mWriter.flush();
        this.mWriter = null;
    }
}

