/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.message.MessageManager;
import java.io.File;
import java.io.FileNotFoundException;

public final class PackageInfo {
    public static final String NAME = PackageInfo.class.getPackage().getName();
    public static final String MSG_PREFIX = "util.iowrappers";
    public static final String WARN_NO_DELETE = "util.iowrappers.WARN_NO_DELETE";
    public static final String ERROR_NO_CLOSE = "util.iowrappers.ERROR_NO_CLOSE";
    public static final String ERROR_ON_OVERWRITE = "util.iowrappers.ERROR_ON_OVERWRITE";
    public static final String EX_NOT_FOUND = "util.iowrappers.EX_NOT_FOUND";

    private PackageInfo() {
    }

    public static String createNoDelete(File file) {
        return MessageManager.messageAsString(WARN_NO_DELETE, new Object[]{file.getAbsolutePath()});
    }

    public static String createNoClose() {
        return MessageManager.messageAsString(ERROR_NO_CLOSE);
    }

    public static FileNotFoundException createNotFound(String name) {
        return new FileNotFoundException(MessageManager.messageAsString(EX_NOT_FOUND, new Object[]{name}));
    }

    public static String errorInOverwrite(String destFileName, String tmpFileName) {
        return MessageManager.messageAsString(ERROR_ON_OVERWRITE, new Object[]{destFileName, tmpFileName});
    }
}

