/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.iowrappers.Closable;
import com.raplix.util.iowrappers.Names;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamWrapper
implements Closable,
Names {
    private OutputStream mStream;
    private boolean mStandard;

    public OutputStreamWrapper(String name) throws FileNotFoundException {
        if ("-".equals(name)) {
            this.mStream = System.out;
            this.mStandard = true;
        } else if ("-:".equals(name)) {
            this.mStream = System.err;
            this.mStandard = true;
        } else {
            this.mStandard = false;
            if (name.startsWith("+")) {
                this.mStream = new FileOutputStream(name.substring("+".length()), true);
            } else {
                this.init(new File(name));
            }
        }
    }

    public OutputStreamWrapper(File file) throws FileNotFoundException {
        this.init(file);
    }

    public OutputStreamWrapper(OutputStream stream, boolean standard) {
        this.mStream = stream;
        this.mStandard = standard;
    }

    public OutputStreamWrapper(OutputStream stream) {
        this(stream, false);
    }

    private void init(File file) throws FileNotFoundException {
        this.mStandard = false;
        this.mStream = new FileOutputStream(file);
    }

    public OutputStream getStream() {
        return this.mStream;
    }

    public boolean getStandard() {
        return this.mStandard;
    }

    public synchronized void close() throws IOException {
        if (this.mStream == null) {
            return;
        }
        if (this.getStandard()) {
            this.mStream.flush();
        } else {
            this.mStream.close();
        }
        this.mStream = null;
    }
}

