/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.iowrappers.Closable;
import com.raplix.util.iowrappers.Names;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamWrapper
implements Closable,
Names {
    private InputStream mStream;
    private boolean mStandard;

    public InputStreamWrapper(String name) throws FileNotFoundException {
        if ("-".equals(name)) {
            this.mStream = System.in;
            this.mStandard = true;
        } else {
            this.init(new File(name));
        }
    }

    public InputStreamWrapper(File file) throws FileNotFoundException {
        this.init(file);
    }

    public InputStreamWrapper(InputStream stream, boolean standard) {
        this.mStream = stream;
        this.mStandard = standard;
    }

    public InputStreamWrapper(InputStream stream) {
        this(stream, false);
    }

    private void init(File file) throws FileNotFoundException {
        this.mStandard = false;
        this.mStream = new FileInputStream(file);
    }

    public InputStream getStream() {
        return this.mStream;
    }

    public boolean getStandard() {
        return this.mStandard;
    }

    public synchronized void close() throws IOException {
        if (this.mStream == null) {
            return;
        }
        if (!this.getStandard()) {
            this.mStream.close();
        }
        this.mStream = null;
    }
}

