/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.util.iowrappers;

import com.raplix.util.file.ZipUtil;
import com.raplix.util.iowrappers.Closable;
import com.raplix.util.iowrappers.Closer;
import com.raplix.util.iowrappers.PackageInfo;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.iowrappers.ZipFileWrapper;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GeneralizedFile
implements Closable {
    private File mReal;
    private TempFile mEntry;
    private boolean mExists;
    private boolean mReadOnly;
    private Stack mEntries = new Stack();
    private Closer mEndCloser = new Closer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneralizedFile(String name) throws IOException {
        File f = new File(name);
        if (f.exists()) {
            this.mExists = true;
            this.mReal = f;
            return;
        }
        try {
            if (f.createNewFile()) {
                f.delete();
                this.mExists = false;
                this.mReal = f;
                return;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        Stack<String> names = new Stack<String>();
        while (!f.exists()) {
            names.push(f.getName());
            if ((f = f.getParentFile()) != null) continue;
            throw PackageInfo.createNotFound(name);
        }
        Closer c = new Closer();
        boolean success = false;
        boolean mPreservePerm = true;
        try {
            while (names.size() > 0) {
                ZipFile zipFile = new ZipFile(f);
                c.register(new ZipFileWrapper(zipFile));
                ZipEntry entry = null;
                String entryName = null;
                this.mExists = false;
                while (names.size() > 0) {
                    entry = zipFile.getEntry(entryName = StringUtil.extend(entryName, "/", (String)names.pop()));
                    if (entry == null || zipFile.getEntry(entryName + '/') != null) continue;
                    this.mExists = true;
                    break;
                }
                this.mEntry = new TempFile();
                this.mEndCloser.register(this.mEntry);
                this.mEntries.push(new Entry(this.mEntry.getFile().getAbsolutePath(), f, entryName, mPreservePerm));
                mPreservePerm = false;
                if (!this.mExists) break;
                f = this.mEntry.getFile();
                ZipUtil.extract(zipFile, entry, f);
            }
            success = true;
            Object var11_11 = null;
            c.closeAll();
            if (!success) {
                this.mEndCloser.closeAll();
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            c.closeAll();
            if (!success) {
                this.mEndCloser.closeAll();
            }
            throw throwable;
        }
    }

    public File getFile() {
        return this.mReal != null ? this.mReal : this.mEntry.getFile();
    }

    public boolean getExists() {
        return this.mExists;
    }

    public void setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.mReal != null || this.mEntry == null) {
            return;
        }
        try {
            if (!this.mReadOnly) {
                while (this.mEntries.size() > 0) {
                    ((Entry)this.mEntries.pop()).update();
                }
            }
        }
        finally {
            this.mEntry = null;
            this.mEndCloser.closeAll();
        }
    }

    private static class Entry {
        private String mTempFile;
        private File mZipFile;
        private String mEntryName;
        private boolean mPreservePerm;

        Entry(String tempFile, File zipFile, String entryName, boolean preservePerm) {
            this.mTempFile = tempFile;
            this.mZipFile = zipFile;
            this.mEntryName = entryName;
            this.mPreservePerm = preservePerm;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Created: '" + this.mTempFile + "' '" + this.mZipFile.getAbsolutePath() + "' '" + this.mEntryName + "'", this);
            }
        }

        void update() throws IOException {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Updating: '" + this.mTempFile + "' '" + this.mZipFile.getAbsolutePath() + "' '" + this.mEntryName + "'", this);
            }
            ZipUtil.update(this.mTempFile, this.mZipFile, this.mEntryName, this.mPreservePerm);
        }
    }
}

